/*
 * kernel.c
 *
 *  Created on: Apr 21, 2015
 *      Author: jlavz6
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <unistd.h>
#include <rtai_fifos.h>
#include <rtai_sched.h>
#include <rtai_sem.h>

MODULE_LICENSE("GPL");

RT_TASK task1,task2;
RTIME period;
unsigned long *map_address;
unsigned long *pbdr;
unsigned long *pbddr;
unsigned long *ptr1;
unsigned long *softInt;
unsigned long *softClear;
unsigned long *softEn;
int check;
int get = 0;
int number;
SEM sem1;
static void red_light(int x)
{
	while(1)
	{
		rt_sem_wait(&sem1);//acquire semaphore
		if(check == 1)
		{
			*pbdr &= 0xFFFFFF7F;//Turn off the green led
			*pbdr |= 0x00000020;//Turn on the red led representing system has reached 75 degrees fahrenheit
			rt_sleep(period);
			check = 0;
		}
		rt_sem_signal(&sem1);//release semaphore
	}
}

static void green_light(int z)
{
	while(1)
	{
		rt_sem_wait(&sem1);//acquire semaphore
		*pbdr &= 0xFFFFFFDF;//Turn off the red led
		rt_sleep(period);
		*pbdr |= 0x000000080;//Turn on the green led to represent system is below 75 degrees fahrenheit
		rt_sem_signal(&sem1);//release semaphore
	}
}

static void my_soft_handler(unsigned irq_num, void *cookie)//handler for interrupt (63)
{
	ptr1 = (unsigned long *)__ioremap(0x800C0000, 4096, 0);//Map to physical address for soft Interrupt register

	//Soft Interrupt Data
	softInt = ptr1 + 6;//VIC2SoftInt
	softEn = ptr1 + 4;//VIC2IntEnable
	softClear = ptr1 + 7;//VIC2SoftIntClear

	rt_disable_irq(63);//disable interrupt

	get = rtf_get(0,(void *)&number,sizeof(int));//Receive temperature in Fahrenheit through real time fifo
	if(get < 0)
	{
		printk("Error in receiving from the fifo.\n");
	}

	if(number >= 75)//If system is greater that 75 degrees fahrenheit, internal fan on
	{
		rt_task_resume(&task2);//Red light
		check = 1;//Flag fan
		printk("Fan will turn on!\n");
	}
	else
	{
		check = 0;
		printk("System cool!\n");
	}

	*softClear |= 0x80000000;//clear interrupt 63
	rt_enable_irq(63); //enable interrupt
}


int init_module(void)
{
	rt_sem_init(&sem1,1);//initialize semaphore
	map_address = (unsigned long *)__ioremap(0x80840000,4096,0);//Map address for port b register
	ptr1 = (unsigned long *)__ioremap(0x800C0000, 4096, 0);//Map to physical address for soft Interrupt register
	pbdr = map_address + 1;//Offset to port B data register
	pbddr = map_address + 5;//Offset to port B data direction register
	*pbddr |= 0x000000E0;//Sets the three led lights to be output
	*pbdr &= 0xFFFFFF1F;//Turn all lights off to begin

	rtf_create(0,sizeof(int));//Create realtime fifo
	softInt = ptr1 + 6;//VIC2SoftInt
	softEn = ptr1 + 4;//VIC2IntEnable
	softClear = ptr1 + 7;//VIC2SoftIntClear

	//Set to periodic mode
	rt_set_periodic_mode();

	//Assign period
	period = start_rt_timer(nano2count(1000000000));

	rt_request_irq(63, my_soft_handler, 0, 1); //attach handler to interrupt line

	*softClear |= 0x80000000;//Clearing Soft Interrupt
	*softEn |= 0x80000000;//Enabling Soft Interrupt

	//Initialize real time task
	rt_task_init(&task1,green_light,0,256,0,0,0);
	//Resume real time task
	rt_task_resume(&task1);

	//Initialize real time task
	rt_task_init(&task2,red_light,0,256,0,0,0);
	//Resume real time task

	rt_enable_irq(63); //enable soft interrupt
	return 0;
}

void cleanup_module(void)
{
	rt_task_delete(&task1);//Delete real time task
	rt_task_delete(&task2);//Delete real time task
	stop_rt_timer();//Stop real time timer
	rtf_destroy(0);//Delete Real Time Fifo
	rt_sem_delete(&sem1);//Delete semaphore
	rt_release_irq(63);//release soft interrupt
	printk("MODULE REMOVED\n");
}
