/*
 * untitled.c
 * 
 * Copyright 2015  <pi@raspberrypi>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * 
 */



#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/time.h>
#include <semaphore.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <sys/mman.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <time.h>
#include <sys/stat.h>
#include <net/if.h>
#include <sys/ioctl.h>

//Initialize the global variables needed by all threads
char* InitializeSocket(char *port);
pthread_mutex_t mutex;
pthread_cond_t sendCondition, listenCondition;
int ardSocket, expect = 0;
unsigned int length;
size_t size = (sizeof(char) * 40), recvd;
char *IP;
struct sockaddr_in anybody, from, bSock;

//Listen Routine handles reading messages from Arduino and writing to log file
void *ListenRoutine(void *ptr)
{
	sleep(5);
	char *checkIP;
	time_t now;
	struct tm *nowt;
	FILE *fptr;
	char *buffer = malloc(sizeof(char) * 40);

	//Check flag that indicates if a message should be expected
	if(expect)
	{
		//Open the log file
		if((fptr = fopen("log.txt", "w+")) == NULL)
		{
			printf("Error opening log file!\n");
			pthread_exit(0);
		}
		
		recvfrom(ardSocket, buffer, size, 0, (struct sockaddr *)&from, &length);
		
		checkIP = malloc(sizeof(from.sin_addr));
		checkIP = inet_ntoa(from.sin_addr);
		//Check that the message is from the Arduino and not the Pi broadcast
		if(strcmp(checkIP, "192.168.1.114") != 0)
		{
			//Calculate the time of the message and convert to readable string
			struct timeval time;
			gettimeofday(&time, NULL);
			fprintf(fptr, "%s", "From Arduino:");
			fprintf(fptr, "%s", buffer);
			fflush(fptr);
			
			char tmbuf[64], buf[64];

			now = time.tv_sec;
			nowt = localtime(&now);
			strftime(tmbuf, sizeof tmbuf, "%Y-%m-%d %H:%M:%S", nowt);
			snprintf(buf, sizeof buf, "%s.%06d", tmbuf, (int)time.tv_usec);
			//Write the arduino message and time to the file
			fprintf(fptr, "%s", buf);
			fflush(fptr);
			printf("%s %s\n", buffer, buf);
			fflush(stdout);
			bzero(buffer, size);
			expect = 0;
		}
		//Close the file
		fclose(fptr);
			
	}
	//Free the buffer and exit
	free(buffer);
	pthread_exit(0);
	
}
//Send Routine controls sending messages to Arduino
void *SendRoutine(void *ptr)
{
	char *send = malloc(sizeof(char) * 40);
	int counter = 0;
	
	pthread_t thread;
	pthread_attr_t thread_attr; 
	//Wait on the condition variable for the signal from the scheduler
	pthread_mutex_lock(&mutex);	
	printf("waiting\n");
	pthread_cond_wait(&sendCondition, &mutex);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
	pthread_attr_init(&thread_attr);
	
	while(1)
	{		
		//use counter and modulus division to determine which command needs to go.
		//Also check the flag that a message it not currently being waited on
		if(!expect && (counter % 2) == 0)
		{
			//Send water message
			send = "Water";	
			recvd =  sendto(ardSocket, send, strlen(send) + 1, 0, (struct sockaddr *)&bSock, length);
			expect = 1;
			counter++;
		}
		
		else if(!expect && (counter % 2) == 1)
		{
			//send food message
			send = "Food";
			recvd =  sendto(ardSocket, send, strlen(send) + 1, 0, (struct sockaddr *)&bSock, length);
			expect = 1;
			counter++;
		}
		//Create the listener thread to handle arduino response
		pthread_create(&thread, &thread_attr, &ListenRoutine, NULL);
		pthread_join(thread, NULL);
		
		send = "";
		
		
		pthread_mutex_unlock(&mutex);
	}

	free(send);
	pthread_exit(0);
}


void *Scheduler(void *ptr)
{
	time_t now;
	struct tm *nowt;
	
	while(1)
	{
		//int i;
		struct timeval time;
		gettimeofday(&time, NULL);
		
		char tmbuf[64], buf[64];
		//Scheduler calculate system times for schedule (Not really Used)
		now = time.tv_sec;
		nowt = localtime(&now);
		strftime(tmbuf, sizeof tmbuf, "%Y-%m-%d %H:%M:%S", nowt);
		snprintf(buf, sizeof buf, "%s.%06d", tmbuf, (int)time.tv_usec);
		pthread_mutex_lock(&mutex);
		printf("Sending\n");
		//When it is time send the signal to the Sender thread
		pthread_cond_signal(&sendCondition);
		pthread_mutex_unlock(&mutex);
		sleep(300);
		//Sleep then signal again for so the second command is sent
		pthread_mutex_lock(&mutex);
		printf("Sending\n");
		pthread_cond_signal(&sendCondition);
		pthread_mutex_unlock(&mutex);
		//Sleep until next cycle
		sleep(300);
	}
			
}

int main(int argc, char** argv)
{
	int i;
	
	char *IP;

	srand(time(NULL));
	
	
	if(argc < 2)
	{
		printf("no port specified\n");
		return 1;
	}
	//Set up sockets using port specified by user
	IP = InitializeSocket(*(argv + 1));

	printf("%s\n", IP);
	//Initialize and create/join threads
	pthread_t threads[2];
	pthread_attr_t thread_attr; 
	pthread_cond_init(&sendCondition, NULL);
		
	pthread_mutex_init(&mutex, NULL);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
	pthread_attr_init(&thread_attr);

	for(i = 0; i < 2; i++)
	{
		if(i == 0)
		{
			pthread_create(&threads[i], &thread_attr, &SendRoutine, (void *)&i);
		}
		else if(i == 1)
		{
			pthread_create(&threads[i], &thread_attr, &Scheduler,  (void *)&i);
		}
		
	}
	
	for(i = 0; i < 2; i++)
	{
		pthread_join(threads[i], NULL);
		sleep(2);
	}
		
	
	
	close(ardSocket);
	
	return 0;
}

char* InitializeSocket(char *port)
{
	char *IP;
	int result, broadcast = 1;
	
	// Create UDP socket.
	ardSocket = socket(AF_INET, SOCK_DGRAM, 0);
	
	// Set Socket options to BROADCAST
	if((result = setsockopt(ardSocket, SOL_SOCKET, SO_BROADCAST, &broadcast, sizeof(broadcast))) == -1)
			printf("Error setting socket to broadcast!\n");

	length = sizeof(struct sockaddr_in);

	// initialize structure memory
	bzero((char *)&anybody, sizeof(anybody));

	// initialize port address for broadcast and receive
	anybody.sin_family = AF_INET;
	anybody.sin_port = htons(atoi(port));
	anybody.sin_addr.s_addr = INADDR_ANY;
	bSock.sin_family = AF_INET;
	bSock.sin_port = htons(atoi(port));
	bSock.sin_addr.s_addr = htonl(INADDR_BROADCAST);

	// create ifreq and get IP of ethernet port
	struct ifreq ifr;
	ifr.ifr_addr.sa_family = AF_INET;
	strncpy(ifr.ifr_name, "eth0", IFNAMSIZ-1);

	ioctl(ardSocket, SIOCGIFADDR, &ifr);

	IP = malloc(sizeof(inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr)));

	IP = inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr);
	
	// Bind socket to listen to any IP
	if((bind(ardSocket,(struct sockaddr *)&anybody, sizeof(anybody))) < 0)
		printf("Error binding socket\n");
		
	return IP;
}




