#!/bin/bash

# Designates the start of a server run #
echo "----------------- START OF SERVER RUN -----------------" > serv.log
echo "----------------- START OF NGROK RUN ------------------" > ngrok.log

# Starts the python and ngrok programs in the background #
python ~/ece4220/receive.py &
ngrok -log=stdout 5000 > ngrok.log &

# Creates "brew.log" is not already created  #
if [ ! -e "brew.log" ] ; then
    touch brew.log
fi

# Sleeps for 3 seconds to allow programs and connections to start and starts the "brew" program #
sleep 3
sudo ./brew &

# Saves the site that it is using #
site="$(grep -o 'http://[0-9a-z]\+\.ngrok\.com' ngrok.log | uniq)"

# Displays on screen what programs were started #
echo "Started python server"
echo "Started ngrok port service @" $site
echo "Started coffee program"