#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <wiringPi.h>
#include <wiringPiSPI.h>
#include <wiringPiI2C.h>
#include "mcp3004.h"

#define BASE 100
#define SPI_CHAN 0
int i2cHandler; //file descriptor for i2c communication
int steeringVal, brakeVal, biasVal, accelVal; //value read from the ADC
char buffer[4]; //store the processed value
char inputBuffer; //i2c input buffer. receive command from the Arduino
void readVal(){
	mcp3004Setup (BASE, SPI_CHAN) ; //ADC initialization setup from the library
	while(1){
		steeringVal = analogRead(BASE); //read values from ADC
		brakeVal = analogRead(BASE+1);
		biasVal = analogRead(BASE+2);
		accelVal = analogRead(BASE+3);
		printf("%d %d %d %d\n", buffer[0], buffer[1], buffer[2], buffer[3]); //print the processed value
	}
}
void writeVal(){
	
	while(1){
		read(i2cHandler, &inputBuffer, 4); //read command from the Arduino
		if(inputBuffer == 1){
			printf("%d\n", write(i2cHandler, &buffer, 4)); //write the processed value to the i2c bus
		}
		else{		
		}
		
		usleep(1000); //delay
	}
}
void processVal(){	
	while(1){
		buffer[0] = steeringVal/6; //divide the steering value from 0-1023 to 0-170 degrees
		buffer[1] = brakeVal/6; //divide the brake value from 0-1023 to 0-170 degrees
		if(brakeVal > 10){ //if the brake is pressed, the motor will be turned off
			buffer[2] = 0;
			buffer[3] = 0;
		}
		else{
			if(biasVal < 512){ //if the differential is opened
				if(steeringVal < 512){ //turning left
					buffer[2] = (steeringVal * accelVal / 512) / 4; // right motor speed will depend on the steering angle
					buffer[3] = accelVal / 4;
				}
				else{ //turning right
					buffer[2] = accelVal / 4;
					buffer[3] = ((1023 - steeringVal) * accelVal / 512) / 4; // left motor speed will depend on the steering angle
				}
			}
			else{ // differential is fully locked. both motors run at the same speed
				buffer[2] = accelVal / 4;
				buffer[3] = accelVal / 4;
			} //accelerator is divided by 4 to adjust the value from 0-1023 to 0-255 because the data is sent by byte and Arduino DAC only handle 8 bit of data
		}
	}
}
int main(){
	wiringPiSetup(); //initialize the wiringPi library
	i2cHandler = wiringPiI2CSetup(0x04); //initialize the i2c communication.
	printf("%d\n", i2cHandler);
	pthread_t readThread, processThread, writeThread; //pthread initialization
	pthread_create (&readThread, NULL, (void *) &readVal, NULL);
    pthread_create (&writeThread, NULL, (void *) &writeVal, NULL);
	pthread_create (&processThread, NULL, (void *) &processVal, NULL);
	pthread_join(readThread, NULL);
    pthread_join(writeThread, NULL);
	pthread_join(processThread, NULL);
	return 0;
}