int steeringVal, brakeVal, leftMotor, rightMotor; //buffer value
#include <Wire.h>
#include <Servo.h>

Servo steeringServo, brakeServo;

void setup()
{
  Wire.begin(4);                // join i2c bus with address #4
  Wire.onReceive(receiveEvent); // initialize interrupt when data is received.
  Wire.onRequest(requestEvent); // initialize interrupt when data is requested.
  Serial.begin(9600);           // start serial for output
  steeringServo.attach(3); //initialize the servo
  brakeServo.attach(9);
  pinMode(5, OUTPUT); //initialize both motors. set the data direction registers, etc.
  pinMode(6, OUTPUT);
}

void loop()
{  
  delay(100);
  steeringServo.write(steeringVal); //write the values
  brakeServo.write(brakeVal);
  analogWrite(5, leftMotor);
  analogWrite(6, rightMotor);
  
}

// function that executes whenever data is received from master
// this function is registered as an event, see setup()
void receiveEvent(int howMany)
{
  while (4 < Wire.available()) // loop through all but the last
  {
           
  }
  steeringVal = Wire.read();    // receive byte as an integer
  Serial.println(steeringVal);         // print the integer
  brakeVal = Wire.read();
  Serial.println(brakeVal);
  leftMotor = Wire.read();
  Serial.println(leftMotor);
  rightMotor = Wire.read();
  Serial.println(rightMotor);
}
void requestEvent()
{
  Wire.write(1); // respond with message of 1 byte for synchronization
  // as expected by master
}
