/*
 ============================================================================
 Name        : Project.c
 Author      : nick
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <pthread.h>
#include <string.h>
#include <sys/time.h>
#include <sys/select.h>
#include <sys/types.h>
#include <semaphore.h>
#include <poll.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>


#define MSG_SIZE 40

unsigned long *DDRB;
unsigned long *PORTB;
RTIME BaseP;
struct timeval tv;
void *readFIFO(void *arg);
void *timer(void *arg);
void *keyBoard(void *arg);
void *keyPad(void*arg);
char read_key(int key);
int count, deadLine, num, fifo, flag = 0, codeFlag = 0;
int lastState = 5;
char code[5], buffer, test, control, control2, control3, device = 1;

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

struct sockaddr_in anybody;
struct sockaddr_in from;
struct hostent *hp;
int sock, length, n, boolval = 1, S_M_flag = 0, r = 4, c = 3;
socklen_t clientlen;
char buf[MSG_SIZE], key;

int main(int argc, char *argv[]) {
	if (argc != 2){
		   printf("usage: %s port\n", argv[0]);
	       exit(1);
	}
	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
	   if (sock < 0)
		   error("socket");

	   // change socket permissions to allow broadcast
	 if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
		{
			printf("error setting socket options\n");
			exit(-1);
		}
	 anybody.sin_family = AF_INET;		// symbol constant for Internet domain
	 anybody.sin_port = htons(atoi(argv[1]));				// port field
	 anybody.sin_addr.s_addr = inet_addr("10.3.52.255");	// broadcast address

	 length = sizeof(struct sockaddr_in);		// size of structure

	int fp = open("/dev/mem",O_RDWR|O_SYNC);
	unsigned long *ptr = (unsigned long *)mmap(NULL, getpagesize(),PROT_READ|PROT_WRITE, MAP_SHARED, fp, 0x80840000);//get the mmap address
	//assign addresses to the pointers for each port.
	DDRB = (unsigned long *)((char*)(ptr+0x05));
	PORTB = (unsigned long *)((char*)(ptr+0x01));
	fifo = open("/dev/rtf/0", O_RDWR);
	int i,j;
	test = 'z';
	BaseP = start_rt_timer(nano2count(1000000));
	pthread_t thread[4];
	pthread_attr_t thread_attr;
	pthread_attr_init(&thread_attr);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_JOINABLE);
/*
	pthread_create(&thread[0], &thread_attr, keyPad, NULL);
	pthread_create(&thread[1], &thread_attr, timer, NULL);

	pthread_join(thread[1],NULL);
	pthread_join(thread[0],NULL);
*/

	while(control != 'q'){
		printf("Menu\n1. Choose Device:\n2. Change Master:\n3. View Log:\n4. Start:\n");//menu
		scanf("%1s",&control);
		fflush(stdout);
		if(control == '1'){//choose device
			printf("1. Buttons\n2. Keypad\n3. Keyboard\n");
			scanf("%1s",&control2);
			fflush(stdout);
			if(control2 == '1'){
				device = '1';
			}
			else if (control2 == '2'){
				device = '2';

			}
			else if (control2 == '3'){
				device = '3';
			}
		}
		else if(control == '2'){
			printf("1. Master\n2. Slave\n");
			scanf("%1s",&control3);
			fflush(stdout);
			if(control3 == '1'){
				S_M_flag = 1;
			}
			else if(control3 == '2'){
				S_M_flag = 0;
			}
		}
		else if(control == '3'){//for fairCom but not used
			printf("LOG\n");
		}
		else if(control == '4'){//start the unlocking process
			//bzero(code,5);
			bzero(buf,MSG_SIZE);
			flag = 0;
			codeFlag = 0;
			count = 0;
			do{//wait for each client to be ready before starting
					 if(buf[0] != '!'){
					 sprintf(buf,"!%d",S_M_flag);
					 printf("%s\n",buf);

					n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&anybody, length);
					if (n  < 0){
					 error("sendto");
					 }

					 }
					bzero(buf,MSG_SIZE);
					 n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
					 printf("%s\n",buf);
					 if(!(strncmp(buf, "@no", 3))){
						 flag = 1;
						 break;
					 }
				}
				while ((strncmp(buf,"*ok", 3)));
			if(S_M_flag == 1){//allow the master client to go first

			}
			else if(S_M_flag == 0){
				do{
					bzero(buf,MSG_SIZE);
					n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
					 printf("%s\n",buf);

				}
				while ((strncmp(buf,"*ok", 3)));
			}
			if(device == '1'){//run what ever deivece was selected from the menu
				//system("insmod ProjectKernel.o");
				pthread_create(&thread[0], &thread_attr, readFIFO, NULL);
				//pthread_create(&thread[1], &thread_attr, timer, NULL);

				pthread_join(thread[0],NULL);

				if(count == 4){
					bzero(buf,MSG_SIZE);
					if(S_M_flag == 1){
						strcat(buf,"#");
					}
					else{
						strcat(buf,"$");
					}
					strcat(buf,code);
					printf("%s|\n",buf);
				 // send message to anyone there...
					n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&anybody, length);
				 if (n < 0)
				 error("Sendto");
				}
				else{
					flag = 1;
				}
				//read(fifo,&buffer,sizeof(buffer));
				//system("rmmod ProjectKernel");
			}
			else if(device == '2'){
				//pthread_create(&thread[1], &thread_attr, timer, NULL);
				pthread_create(&thread[2], &thread_attr, keyPad, NULL);

				pthread_join(thread[2],NULL);

				if(count == 4){
					bzero(buf,MSG_SIZE);
					if(S_M_flag == 1){
						strcat(buf,"#");
					}
					else{
						strcat(buf,"$");
					}
					strcat(buf,code);
				// send message to anyone there...
				n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&anybody, length);
				if (n < 0)
				 error("Sendto");
				}
				else{
					flag = 1;
				}
			}
			else if(device == '3'){
				//pthread_create(&thread[1], &thread_attr, timer, NULL);
				pthread_create(&thread[1], &thread_attr, keyBoard, NULL);
				pthread_join(thread[1],NULL);
				//pthread_join(thread[1],NULL);

				if(count == 4){
					bzero(buf,MSG_SIZE);
					if(S_M_flag == 1){
						strcat(buf,"#");
					}
					else{
						strcat(buf,"$");
					}
					strcat(buf,code);
				// send message to anyone there...
				n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&anybody, length);
				if (n < 0)
				 error("Sendto");
				}
				else{
					flag = 1;
					//bzero(buf,MSG_SIZE);
					// sprintf(buf,"%qq");
					//n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&anybody, length);
				}
			}
			if(S_M_flag == 1 && flag == 0){//wait for the server to send the result back
				do{
					bzero(buf,MSG_SIZE);
					n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
					 if(!(strncmp(buf, "@error", 6))){
						 flag = 1;
						 break;
					 }
				}
				while ((strncmp(buf,"@ok", 3)));
			}
			else if(S_M_flag == 0 && flag == 0){
				do{
					bzero(buf,MSG_SIZE);
					n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
					 if(!(strncmp(buf, "@error", 6))){
						 flag = 1;
						 break;
					 }
				}
				while ((strncmp(buf,"@ok", 3)));
			}
			if(flag == 1){//print the result
				printf("Code was incorrect, not entered in time, or no master\n");
			}
			else{
				bzero(buf,MSG_SIZE);
				n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&from, &length);
				printf("Code %s is correct\n",buf);
			}
		}

	}

	printf("%s\n",code);
	close(fifo);
	close(sock);
	return 1;
}
//real time task timer
void *timer(void *arg){
	RT_TASK* rttask = rt_task_init(nam2num("timer"),0,512,256);
	rt_task_make_periodic(rttask,rt_get_time()+0*BaseP,1000*BaseP);
	deadLine = 0;
	while(count < 4){
		rt_task_wait_period();
		deadLine++;
		if(deadLine > 10){
			break;
		}
		printf("Timer, %d\n",deadLine);
	}
	if(count < 4){
		write(fifo,&test,sizeof(buffer));
	}

	pthread_exit(0);
}
//read the FIFO from the Kernel Module for the button interrupts.
void *readFIFO(void *arg){
	count = 0;
	while(count < 4){
		if(read(fifo,&buffer,sizeof(buffer))){	//when the named pipe is ready
			if(buffer == 'z'){
				break;
			}
			printf("Count = %d , Got It %c\n",count, buffer);
			code[count] = buffer;
			count++;
		}
		if(deadLine > 14){
			break;
		}
	}
	pthread_exit(0);
}
//read from the keyboard
void *keyBoard(void *arg){
	struct pollfd mypoll = { STDIN_FILENO, POLLIN|POLLPRI };
	count = 0;
	while(1){
		if(poll(&mypoll, 1, 5000)){
			scanf("%4s", &code);
			printf("Read string - %s\n", code);
			count = 4;
		}
		else if(deadLine > 14){
			break;
		}
		else{
			break;
			//puts("Read nothing");
		}
	}
	pthread_exit(0);
}
//read from the keypad using the polling method
void *keyPad(void*arg){
	int i,j;
	*DDRB = 0xE0;//Switches to be input / led output
	*PORTB = 0xFF;//Turn on all pins in PORTB
	count = 0;
	while(count < 4){
		for(i = 0; i < c; i++){
			*PORTB ^= 1<<(i+5);
			for(j = 0; j < r; j++){
				if(!(*PORTB & 1<<j)){
					key = read_key((i+j*3));
					printf("Keypad %c hit\n",key);
					code[count] = key;
					count++;
				}
			}
			usleep(40000);
			*PORTB = 0xFF;//Turn on all pins in PORTB
		}
		if(deadLine > 10){
			printf("Did not enter the code in time\n");
			break;
		}
	}
	pthread_exit(0);
}
//for turning the keypad rows and cols into a number.
char read_key(int key){
	char a = ' ';
	switch(key){
		case 0:
			a = '1';
			break;
		case 1:
			a = '2';
			break;
		case 2:
			a = '3';
			break;
		case 3:
			a = '4';
			break;
		case 4:
			a = '5';
			break;
		case 5:
			a = '6';
			break;
		case 6:
			a = '7';
			break;
		case 7:
			a = '8';
			break;
		case 8:
			a = '9';
			break;
		case 9:
			a = '*';
			break;
		case 10:
			a = '0';
			break;
		case 11:
			a = '#';
			break;
		default:
			break;
	}
	return a;
}


