/*
 ============================================================================
 Name        : ProjectKernel.c
 Author      : nick
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */
#ifndef MODULE
#define MODULE
#endif
#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_fifos.h>	// for FIFOs
#include <linux/time.h>
#include <linux/delay.h>

MODULE_LICENSE("GPL");

//register address variables
unsigned long *PBDR;
unsigned long *PBDDR;
unsigned long *PFDR;
unsigned long *PFDDR;
unsigned long *GPIOBIntEn;
unsigned long *GPIOBIntType1;
unsigned long *GPIOBIntType2;
unsigned long *GPIOBEOI;
unsigned long *IntStsB;
unsigned long *GPIOBDB;


static void my_handler(unsigned irq_num, void * cookie){
	char num;
	rt_disable_irq(irq_num);//disable the interrupt while this handler executes

	//determine which button has been pressed
	if (*IntStsB & 1<<4) num = '5';
	else if (*IntStsB & 1<<3) num = '4';
	else if (*IntStsB & 1<<2) num = '3';
	else if (*IntStsB & 1<<1) num = '2';
	else if (*IntStsB & 1<<0) num = '1';
	else num = '0';
	*GPIOBEOI |= 0x1F;//interrupt clear
	//printk("Hello %c\n",num);
	rtf_put(0,&num,(sizeof(char)));//put the button that i am pressing number into the fifo
	//mdelay(100);
	rt_enable_irq(irq_num);////re enable the interrupt


}
int init_module(void){
	rt_request_irq(59, my_handler, 0, 1);	//hardware interrupt
	unsigned long *ptr = (unsigned long *)__ioremap(0x80840000,4096,0);//reading register address

	//assigning registers
	PBDDR = (unsigned long *)((char*)(ptr+0x05));//assigning the address of PBDDR
	*PBDDR = 0xE0;//Switches to be input
	PBDR = (unsigned long *)((char*)(ptr+0x01));//assigning the address of PBDR
	*PBDR = 0xFF;//Turn on all pins in PORTB
	PFDDR = (unsigned long *)((char*)(ptr+0x0D));//assigning the address of PFDDR
	*PFDDR |= 1<<1;//make GPIOF second bit to be output
	PFDR = (unsigned long *)((char*)(ptr+0x0C));//assigning the address of PFDR
	*PFDR |= 1<<1;
	GPIOBIntEn = (unsigned long *)((char*)ptr + 0xB8);
	*GPIOBIntEn = 0x1F;//GPIOB interrupt enable register
	GPIOBEOI = (unsigned long*)((char*)ptr + 0xB4);
	*GPIOBEOI |= 0x1F;//GPIOB end of interrupt
	GPIOBIntType1 = (unsigned long*)((char*)ptr + 0xAC);
	*GPIOBIntType1 |= 0x1F;//0-level sensitive 1-edge sensitive
	GPIOBIntType2 = (unsigned long*)((char*)ptr + 0xB0);
	*GPIOBIntType2 &= ~0x1F;//1-Falling edge 0-rising edge
	IntStsB = (unsigned long*)((char*)ptr + 0xBC);
	GPIOBDB = (unsigned long*)((char*)ptr + 0xC4);
	*GPIOBDB = 0x1F;
	rt_enable_irq(59);//hardware interrupt enable

	rtf_create(0, sizeof(char)); //create fifo 0 to communicate with the other process

    return 0;
}

void cleanup_module(void){
	*PBDR = 0xFF;				//Turn on all pins in PORTB
	rt_release_irq(59);			//releasing hardware interrupt
	rtf_destroy(0);
}
