#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <pthread.h>
#include <string.h>
#include <sys/time.h>
#include <sys/select.h>
#include <sys/types.h>
#include <semaphore.h>
#include <poll.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>

#define MSG_SIZE 40


void error(const char *msg)
{
    perror(msg);
    exit(0);
}
RTIME BaseP;
struct timeval tv;
void *timer(void *arg);
int deadLine, timeFlag = 0, stopFlag;
struct sockaddr_in server;
struct sockaddr_in client;
struct hostent *hp;
int sock, length, n, portNumber,mcount, count;
int boolval = 1;		// for a socket option
socklen_t clientlen;
char buf[MSG_SIZE], code[10];
char correctCode[10] = "12341234";

int main(int argc, char *argv[]){
	if (argc == 2){
			portNumber = atoi(argv[1]);
		}
		else {
			portNumber = 2000;
		}
	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.

    length = sizeof(server);			// length of structure
    bzero(&server,length);			// sets all values to zero. memset() could be used
    server.sin_family = AF_INET;		// symbol constant for Internet domain
    server.sin_addr.s_addr = INADDR_ANY;		// IP address of the machine on which
											// the server is running
    server.sin_port = htons(portNumber);	// port number

    // binds the socket to the address of the host and the port number
    if (bind(sock, (struct sockaddr *)&server, length) < 0)
 	 	error("binding");

    // set broadcast option
    if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
 	{
		printf("error setting socket options\n");
 		exit(-1);
	}

    clientlen = sizeof(struct sockaddr_in);	// size of structure
    BaseP = start_rt_timer(nano2count(1000000));
    pthread_t thread;
    pthread_attr_t thread_attr;
    pthread_attr_init(&thread_attr);
    pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_JOINABLE);

    while (1){
    	bzero(&buf,MSG_SIZE);//clear the buffer
    	n = recvfrom(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, &clientlen);//receive the message
    	printf("REC: %s\n",buf);
    	if(buf[0] == '!'){//wait for the clients to signal they are ready.
    		count++;
    		if(buf[1] == '1'){
    			mcount++;
    		}
    		if(count == 2 && mcount == 1){
    			bzero(&buf,MSG_SIZE);//clear the buffer
    			sprintf(buf, "*ok");
    			client.sin_addr.s_addr = inet_addr("10.3.52.255");
    			n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    			count = 0;
    			mcount = 0;
    		}
    		else if(count == 2 && mcount != 1){//both slaves or both masters causes an error
    			bzero(&buf,MSG_SIZE);//clear the buffer
    			sprintf(buf, "@no");
    			client.sin_addr.s_addr = inet_addr("10.3.52.255");
    			n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    			count = 0;
    			mcount = 0;
    		}
    	}
    	else if(buf[0] == '#'){//read from the master client into the first half of the code.
    		code[0] = buf[1];
    		code[1] = buf[2];
    		code[2] = buf[3];
    		code[3] = buf[4];
    		//pthread_create(&thread, &thread_attr, timer, NULL);
    		bzero(&buf,MSG_SIZE);//clear the buffer
    		sprintf(buf, "*ok");
    		client.sin_addr.s_addr = inet_addr("10.3.52.255");
    		n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    	}
    	else if(buf[0] == '$' && timeFlag == 0){//read from the slave client into the second half of the code.
    		code[4] = buf[1];
			code[5] = buf[2];
			code[6] = buf[3];
			code[7] = buf[4];
			stopFlag = 1;
    	}
    	else if(buf[0] == '%'){//error in the code
    		bzero(&buf,MSG_SIZE);//clear the buffer
    		sprintf(buf, "@error");
    		client.sin_addr.s_addr = inet_addr("10.3.52.255");
    		n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    	}
    	if(stopFlag == 1 && !(strncmp(correctCode,buf,8))){// the code is correct signal the clients
    		bzero(&buf,MSG_SIZE);//clear the buffer
    		sprintf(buf,"@ok");
    		client.sin_addr.s_addr = inet_addr("10.3.52.255");
    		n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    		bzero(&buf,MSG_SIZE);//clear the buffer
    		sprintf(buf, "%s",code);
    		client.sin_addr.s_addr = inet_addr("10.3.52.255");
    		n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    		stopFlag = 0;
    	}
    	else if(stopFlag == 1){//error in the code
			bzero(&buf,MSG_SIZE);//clear the buffer
			sprintf(buf, "@error");
			client.sin_addr.s_addr = inet_addr("10.3.52.255");
			n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
			stopFlag = 0;
    	}
    	if(timeFlag == 1){//code did not finish in time
    		bzero(&buf,MSG_SIZE);//clear the buffer
    		sprintf(buf, "@error");
    		client.sin_addr.s_addr = inet_addr("10.3.52.255");
    		n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
    		timeFlag = 0;
    	}
    }
}

void *timer(void *arg){
	RT_TASK* rttask = rt_task_init(nam2num("timer"),0,512,256);
	rt_task_make_periodic(rttask,rt_get_time()+0*BaseP,1000*BaseP);
	timeFlag = 0;
	stopFlag = 0;
	deadLine = 0;
	while(deadLine > 10){
		rt_task_wait_period();
		deadLine++;
		if(stopFlag == 1){
			break;
		}
		if(deadLine >= 10){
			timeFlag = 1;
			bzero(&buf,MSG_SIZE);//clear the buffer
			sprintf(buf, "stop");
			client.sin_addr.s_addr = inet_addr("10.3.52.255");
			n = sendto(sock, buf, MSG_SIZE, 0, (struct sockaddr *)&client, clientlen);
		}
	}

	pthread_exit(0);
}
