#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <pthread.h>

void* thread0();
void* thread1();

typedef struct {
    int studentID;
} students;

typedef struct {
    int attendaced;
    int total;
} classes;


//Global variables
int fifo;
char filename[] = "fifo.tmp";
char filename2[] = "fifo2.tmp";
classes class;
int atten = 0;
students student[50];


int main(int argc, char *argv[]){
    
    int timer_atend = 0;
    
    // Create FIFO
    int s_fifo = mkfifo(filename, S_IRWXU);
    	
    if (s_fifo != 0)
    {
        printf("mkfifo() error: %d\n", s_fifo);
        return -1;
    }
    
    // Create FIFO
    int s_fifo2 = mkfifo(filename2, S_IRWXU);
    
    if (s_fifo2 != 0)
    {
        printf("mkfifo2() error: %d\n", s_fifo2);
        return -1;
    }


    //opening the fifo
	fifo = open(filename, O_RDONLY);
    	
	if (fifo < 0)
    {
        printf("open() error: %d\n", fifo);
        return -1;
    }
    
    printf("please enter the time (in seconds) for the attendace count: \n");
    scanf("%d", &timer_atend);
    printf("%d \n", timer_atend);
    
    pthread_t tid;
    pthread_create(&tid, NULL, thread0, NULL);
    
    int counter=0,i;
    
    //count down the time for enabling attendce
    for (i=timer_atend; i>0; i--) {

        printf("attendce time is: %d \n", i);
        
        sleep(1);
    
    }
    
	// Close and delete FIFO
    close(fifo);
    unlink(filename);
    unlink(filename2);
    
    
        printf("*******************************************\n");
        printf("\t Class total attendace is %d\n", class.total);
        printf("\t Class total register students is %d\n", class.attendaced);
        printf("\t");
        for(i=0;i<atten;i++){
        
            printf("%d ",student[i].studentID);
        
        }
        printf("\n*******************************************");
    
    return 0;

}

//thread for reading from fifo, the students that passes motion sensor
void* thread0(){
    
    char arr2[3];
    int counter =0;
    pthread_t tid;

    while (1) {
        
        //Read from FIFO
        int s_read = read(fifo, arr2, sizeof(arr2));
    
        if (s_read < 0)
        {
            printf("fprintf() error: %d\n", s_read);
        }
    
        counter++;
    
        printf("attendcefifo: %s student entered the class, total %d \n", arr2, counter);
        
        class.total = counter;
        
        pthread_create(&tid, NULL, thread1, NULL);
    
        sleep(1);
    }
    pthread_exit(0);
}

//thread for reading the user data from user program
void* thread1(){
    int value;

    //opening fifo
    int fifo = open(filename2 , O_RDWR);

    //reading data from user program
    read(fifo, &value, sizeof(value));
    
    //print data
    printf("userfifo: %d is a student in class\n", value);
    
    student[atten].studentID = value;
    class.attendaced = ++atten;
    
    pthread_exit(0);
}
