/*
 ============================================================================
 Name        : fpclient.c
 Author      : Stephanie Cahail
 Version     :
 Copyright   : Your copyright notice
 Description : User space for final project that represents central unit/client
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <rtai.h>
#include <rtai_lxrt.h>
#include <pthread.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>
#include <sys/mman.h>
#include <fcntl.h> //for O_RDWR
#include <rtai_fifos.h>
#include <semaphore.h>
#include <pthread.h>

#define MSG_SIZE 70			// message size
int flag = 0; 				// end on flag = 1
int sock, length, n;
int sockExit = 0;				// holds exit request

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

int main(int argc, char *argv[]) {
   int permission = 1;			// broadcast permission value
   socklen_t fromlen;
   struct hostent *hp;
   struct sockaddr_in from;
   struct sockaddr_in addr;
   char hostname[64], IP[16];
   char* warningMessage;
   char buffer[MSG_SIZE];	// to store received messages or messages to be sent.

   sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
   if (sock < 0)
	   error("socket");
   // change socket permissions to allow broadcast
   if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &permission, sizeof(permission)) < 0)
   {
	   printf("error setting socket options\n");
       exit(-1);
   }
   length = sizeof(addr);			// length of structure
   //bzero((char*)&addr,length);		    // sets all values to zero. memset() could be used
   addr.sin_family = AF_INET;		// symbol constant for Internet domain
   addr.sin_port = htons(2000);
   addr.sin_addr.s_addr = inet_addr("10.3.52.255");		// IP address of the machine on which
											 //the server is running


   gethostname(hostname, 64);		//get IP address
   hp = gethostbyname(hostname);
   //bcopy((char*)hp->h_addr, (char*)&addr.sin_addr, hp->h_length);
   strcpy(IP, inet_ntoa(*((struct in_addr *)hp->h_addr)));
   printf("HP name:%s\n", hp->h_name);
   printf("IP Address: %s\n", IP);

   fromlen = sizeof(struct sockaddr_in);	// size of structure

   	//fifo initialization
   	int fifo1 = open("/dev/rtf/0", O_RDWR);
   	if(fifo1 == -1){
   		printf("error.\n");
   		exit(-1);
   	}
   do{
	   // bzero: to "clean up" the buffer. The messages aren't always the same length...
	   bzero(buffer,MSG_SIZE);		// sets all values to zero.
	   printf("Please enter the message (! to exit): ");
	   fgets(buffer, MSG_SIZE-1, stdin);
	   if(buffer[0] != '!'){
		   //sprintf(buffer, "Initializing communication with collars.");
		   n = sendto(sock, buffer, strlen(buffer), 0, (const struct sockaddr *)&addr, length);
		   if (n < 0)
			   error("sendto");
		   // receive temperature status message (general format: "1 has certain temperature status")
		   bzero(buffer, MSG_SIZE);
		   n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&addr, &fromlen);
		   if (n < 0)
			   error("recvfrom");

		   printf("%s \n", buffer); //print warning message concerning pet that has temperature issue
		   if(strstr(buffer, "low") || strstr(buffer, "high")){
			   printf("Reached.\n");
			   flag = 1;
               //write set flag value to kernel via fifo so sound can play
			   if(write(fifo1, &flag, sizeof(flag)) != sizeof(flag)){
				   printf("Fifo pipe write error\n");
				   exit(-1);
			   }
			   usleep(3000000); //sleep for 3 seconds
               //write zero flag value to kernel via fifo so sound can stop
			   flag = 0;
			   if(write(fifo1, &flag, sizeof(flag)) != sizeof(flag)){
				   printf("Fifo pipe write error\n");
				   exit(-1);
			   }
		   }
	   }
   }while(buffer[0] != '!');
    //close socket
   close(sock);
   return 0;
}
