#include <iostream>
#include <string>
#include <cstdlib>
#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <ctime>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>

using namespace std;

pthread_t thread1;

//struct for data being sent to thread
struct person
{
	char name[50];
	int wins;
};
//global person
person stuf;

//function to be threaded
void* thread(void* data)
{
  //making fifos
	int fifoOut;
	int fifoOutTwo;
	mkfifo("fifo",O_RDWR);
	mkfifo("fifo2",O_RDWR);
  //opening fifos
	fifoOut = open("fifo",O_RDWR);
	fifoOutTwo = open("fifo2",O_RDWR);
	//loop to write to fifo
  while(1)
	{
		//these two are returning >0 
		write(fifoOut, &stuf.name, sizeof(string));	
		write(fifoOutTwo,&stuf.wins,sizeof(int));
	}
	pthread_exit(0);
}

//function to get value 1-20
int atkRoll()
{
	return rand()%20+1;
}

//function to get d to d*v value. Ex a 1d6 can go from 1 to 6
int damDie(int d,int v)
{
	int tot=0;
	for(int i=0;i<d;i++)
	{
		tot += rand()%v+1;
	}
	return tot;
}

//class to hold damage values to be passed into damDie()
class Weapon
{
	public:
	string name;
	int num;
	int val;
	
  //empty constructor
	Weapon(){}
	
  //set function 
	void set(string na,int n,int v)
	{
		name=na;
		num=n;
		val=v;
	}
};

//class that is the character the person chooses. Holds stats that would be
//compared during runtime
class Player
{
	public:
	string name;
	string job;
	int hitMax;
	int AC;
	int str;
	int strMod;
	int dex;
	int dexMod;
	int con;
	int conMod;
	int intel;
	int intelMod;
	int wis;
	int wisMod;
	int cha;
	int chaMod;
	Weapon wep;
	
  //constructor to make a Player
	Player(string n,string j,int hit,int ac,int s,int d,int c,int i,int w,int ch,string na,int di,int v)
	{
		name=n;
		job=j;
		hitMax=hit;
		AC = ac;
		str = s;
		dex = d;
		con = c;
		intel = i;
		wis = w;
		cha = ch;
		strMod = (str-10)/2;
		dexMod = (dex-10)/2;
		conMod = (con-10)/2;
		intelMod = (intel-10)/2;
		wisMod = (wis-10)/2;
		chaMod = (cha-10)/2;
		wep.set(na,di,v);
	}
};

//Same as player except does not have a class (job)
class Monster
{
	public:
	string name;
	int hitMax;
	int AC;
	int str;
	int strMod;
	int dex;
	int dexMod;
	int con;
	int conMod;
	int intel;
	int intelMod;
	int wis;
	int wisMod;
	int cha;
	int chaMod;
	Weapon wep;
	
  //constructor for monster
	Monster(string n,int hit,int ac,int s,int d,int c,int i,int w,int ch,string na,int di,int v)
	{
		name=n;
		hitMax=hit;
		AC = ac;
		str = s;
		dex = d;
		con = c;
		intel = i;
		wis = w;
		cha = ch;
		strMod = (str-10)/2;
		dexMod = (dex-10)/2;
		conMod = (con-10)/2;
		intelMod = (intel-10)/2;
		wisMod = (wis-10)/2;
		chaMod = (cha-10)/2;
		wep.set(na,di,v);
	}
};

int main()
{
  //seed
	srand(time(0));
  //gather first data for fifo
	cout<<"What is your name? ";
	cin>>stuf.name;
  //make thread to send data continuously
	pthread_create(&thread1,NULL,thread,(void *)NULL);
	Player *play;
  //make monster
	Monster mon("Aarakocra",13,12,10,14,10,11,12,11,"Javelin",1,6);
	cout<<"Welcome to the Dungeons and Dragons training sim!"<<endl;
	cout<<"Choose a character to try!"<<endl;
	cout<<"a: Human Fighter, a deadly swordsman wielding a greatsword!"<<endl;
	cout<<"b: Human Wizard, a powerful made who throws missles of magic!"<<endl;
	char a;
	bool go = false;
  //loop until player chooses a character
	while(!go)
	{
		cin>>a;
		if(a=='a'||a=='A')
		{
			Player humFig("Human","Fighter",13,16,15,12,14,13,10,8,"Greatsword",2,6);
			play = &humFig;
			go = true;
		}
		else if(a=='b'||a=='B')
		{
			Player humWiz("Human","Wizard",8,13,8,14,13,15,12,10,"Magic Missle",4,4);
			play = &humWiz;
			go = true;
		}
		else
			cout<<"That was not an option, try again: ";
	}
	
	cout<<"Now you are ready to do battle!"<<endl;
	cout<<"Your oponents will be the "<<mon.name<<endl;
	int myHp = play->hitMax;
	int badHp = mon.hitMax;
	int count=-1;
  
  //loops till you die or quit
	while(myHp>0)
	{
		count+=1;
		char dec;
		bool make = false;
		myHp = play->hitMax;
		badHp = mon.hitMax;
		cout<<"An oponent arrives!"<<endl;
		cout<<"What will you do?"<<endl;
    //loop fight till there is a victor
		while(badHp>0 && myHp>0)
		{
			make = false;
			cout<<"a) Fight\tor\tb) Flee"<<endl;
			while(!make)
			{
				cin>>dec;
				if(dec=='a'||dec=='A')
				{
					make = true;
					int atR = atkRoll();
					if(atR>mon.AC)
					{
						cout<<"You rolled a "<<atR<<" which beat your enemie's AC!"<<endl;
						int dmg = damDie(play->wep.num,play->wep.val);
						if(atR==20)
						{
							cout<<"You delt a critical hit!!!"<<endl;
							dmg*=2;
						}
						cout<<"You deal "<<dmg<<"damage to the enemy!"<<endl;
						badHp -= dmg;
					}
					else
						cout<<"Your roll did not beat the enemy's AC, you miss."<<endl;	
				}
				else if(dec=='b'||dec=='B')
				{
					myHp = 0; 
					cout<<"You died running off a cliff. Bummer. Game over."<<endl;
					make = true;
				}
				else
					cout<<"That was not an option, try again: ";
				if(badHp>0 && dec!='b'&& dec!='B')
				{
					int atR = atkRoll();
					if(atR>play->AC)
					{
						cout<<"Enemy rolled a "<<atR<<" which beat your AC!"<<endl;
						int dmg = damDie(mon.wep.num,mon.wep.val);
						if(atR==20)
						{
							cout<<"They delt a critical hit!!!"<<endl;
							dmg*=2;
						}
						cout<<"Enemy delt "<<dmg<<" damage to you!"<<endl;
						myHp -= dmg;
					}
					else
						cout<<"Enemy missed."<<endl;
				}
			}
		}
		if(myHp>badHp)
			cout<<"You won the fight!"<<endl;
		else
			cout<<"You are so dead"<<endl;
	}
  //update into for fifo out
	stuf.wins = count;
  
  //print because the other program wasnt lining up
	cout<<"You won "<<stuf.wins<<" fight(s)."<<endl;
	return 0;
}
