///* 	Name       : test2.c
//	Author     : Shining Sun

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <math.h>
#include <fcntl.h>
#include <pthread.h>
#include <semaphore.h>
#include <ifaddrs.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <sys/stat.h>


#define MSG_SIZE 40			// message size

#define Maxsize 100000			// message size

typedef struct{	//this structure is the argument for passing variables into the childThread
	float xvalue;
	float yvalue;
	float  zvalue;
} thread_data_t;

void error(const char *msg)
{
    perror(msg);
    exit(0);
}

//a child thread to read in data
void *readFile(void *arg);

//setup variables
int sock, n;
struct sockaddr_in anybody, from;
char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
unsigned int length;

int main(int argc, char *argv[])
{
	//port mapping
	int fd = open("/dev/mem",O_RDWR|O_SYNC) ;
	unsigned long *ptr_sft = mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED,fd, 0x800C0000);
	unsigned long *VIC2SoftInt = (unsigned long*) ((char *)ptr_sft + 0x18);


	int boolval = 1;			// for a socket option

	//setup for the thread
	pthread_t thread;
	pthread_attr_t thread_attr;
	pthread_attr_init(&thread_attr);

	//read port number from the user
	if (argc != 2)
	{
	   printf("usage: %s port\n", argv[0]);
       exit(1);
	}

	sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
	if (sock < 0)
		error("socket");

	// change socket permissions to allow broadcast
  	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
  	{
     		printf("error setting socket options\n");
     		exit(-1);
  	}

	   anybody.sin_family = AF_INET;		// symbol constant for Internet domain
	   anybody.sin_port = htons(atoi(argv[1]));				// port field
	   anybody.sin_addr.s_addr = inet_addr("10.3.52.255");	// broadcast address

	   length = sizeof(struct sockaddr_in);		// size of structure

	   pthread_create(&thread, &thread_attr, readFile, NULL);	//creating the readKernel
	   pthread_join(thread, NULL);

	   close(sock);						// close socket.
	   return 0;
}

//multi-thread
//thread to read the file
void *readFile(void *arg){
	//port mapping
	int fd = open("/dev/mem",O_RDWR|O_SYNC) ;
	unsigned long *ptr_sft = mmap(NULL, getpagesize(), PROT_READ|PROT_WRITE, MAP_SHARED,fd, 0x800C0000);
	unsigned long *VIC2SoftInt = (unsigned long*) ((char *)ptr_sft + 0x18);
	//set up fifo
	int fifo_0 = open("/dev/rtf/0", O_RDWR);	//opening the named fifo
	if(fifo_0<0) 	printf("error opening fifo\n");

	 int i = 0;

	 thread_data_t data[Maxsize];
	 float total[Maxsize];
	 //set flag to illustrate fall
	 int fall=0;

	 //read file
	 FILE *fp;
	 fp =fopen("TEST.TXT", "r");
	 do
	 {
		  // bzero: to "clean up" the buffer. The messages aren't always the same length...
		  bzero(buffer,MSG_SIZE);		// sets all values to zero. memset() could be used
		  fall = 0;

		  if (!fp) printf("Error Reading");

		  else{

			  //read in data
		  	fscanf(fp,"%f %f %f",&data[i].xvalue,&data[i].yvalue,&data[i].zvalue);

		  	//do calculation
		  	total[i]=sqrt(data[i].xvalue*data[i].xvalue +data[i].yvalue*data[i].yvalue +data[i].zvalue*data[i].zvalue );
		  	printf("Read in Data:%f %f %f %f\n",data[i].xvalue,data[i].yvalue,data[i].zvalue,total[i]);

		  	//judging whether the fall occurs
		  	if(total[i]>380){fall = 1; printf("%d",fall);} else fall =0;
		  	sprintf(buffer, "# %f %f %f %d\n",data[i].xvalue,data[i].yvalue,data[i].zvalue,fall);


			if(fall){
				write(fifo_0, &fall, sizeof(fall));//write to the fifo 0 for the communication with kernel
		  				*VIC2SoftInt |= 0x80000000;//software interrupt flag set up

		  				//print the message
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				 printf("!!!!Fall Occurs!!!\n");
		  				from.sin_addr.s_addr = inet_addr("10.3.52.255");

		  	}
		  	 // send message to anyone there...
		  	n = sendto(sock, buffer, strlen(buffer), 0,(const struct sockaddr *)&anybody,length);
		  			  if (n < 0)	error("Sendto");

		  i++;
	}

	  }while(!feof(fp) && i!=Maxsize && fall != 1);

pthread_exit(0);
}




