/*
 ============================================================================
 Name        : Finalkernel.c
 Author      : 
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#ifndef MODULE
#define MODULE
#endif
#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>
#include <rtai_fifos.h>	// for FIFOs
#include <linux/time.h>


MODULE_LICENSE("GPL");

static RT_TASK mytask;
RTIME period[2];
#define irq_num 59

unsigned long *PBDR;
unsigned long *PBDDR;
unsigned long *PFDR;
unsigned long *PFDDR;
unsigned long *GPIOBIntEn;
unsigned long *GPIOBIntType1;
unsigned long *GPIOBIntType2;
unsigned long *GPIOBEOI;//end of interrupt clear
unsigned long *GPIOBDB;
unsigned long *IntStsB;
unsigned long *RawIntStsB;
unsigned long *VIC2IntEnClear;
unsigned long *VIC2IntEn;
unsigned long *VIC2IntTrigger;


int status;

static void rt_process(int t){
//	light the RED light
	 *PBDR |= 0x20;
	while(1){
//sound the speaker
		(* PFDR) ^= 0x02;
		rt_task_wait_period();
	}
}

static void software_interrupt(unsigned irq, void * cookie){
	rt_disable_irq(63);//disabling software interrupt while this function executes
	int sendfromuser;
	rtf_get(0,(int*)&sendfromuser,sizeof(int));//get data from the fifo
	rt_task_make_periodic(&mytask, rt_get_time(), period[sendfromuser]);//set period with the value from other process
	*VIC2IntEnClear |= 0x80000000;//clear the register
	rt_enable_irq(63);//re enable the interrupt
}


int init_module(void){


	rt_request_irq(63, software_interrupt, 0, 1); //software interrupt

	unsigned long *ptr = (unsigned long *)__ioremap(0x80840000,4096,0);//reading register address
	unsigned long *ptr_sft = (unsigned long *)__ioremap(0x800C0000,4096,0);//reading register address
	//Port B
	PBDDR = (unsigned long *)((char *)ptr+0x14);//assigning the address of PBDDR
	PBDR = (unsigned long *)((char *)ptr + 0x04);

	(* PBDDR) |=  0xE0 ;//set the pin of lights to be input

	//Port FVIC2IntEn
	PFDR =(unsigned long *)((char *)ptr + 0x30);
	PFDDR = (unsigned long *)((char *)ptr + 0x34);
	(* PFDDR) |= 0x02;
	(* PFDR) ^=0x02 ;
	GPIOBIntEn = (unsigned long *)((char *)ptr + 0xB8);
	(*GPIOBIntEn) |= 0x1f;

	GPIOBIntType1 = (unsigned long *)((char *)ptr + 0xAC);
	(*GPIOBIntType1) |= 0x1f;

	GPIOBIntType2 = (unsigned long *)((char *)ptr + 0xB0);
	(*GPIOBIntType2) |= 0xE0;

	GPIOBEOI =(unsigned long *)((char *) ptr +0xB4);
	GPIOBDB = (unsigned long *)((char *)ptr +0xC4);
	*GPIOBDB |= 0x1F;
	IntStsB =(unsigned long *)((char *) ptr +0xBC);

	VIC2IntEn =(unsigned long *)((char *) ptr_sft +0x10);
	*VIC2IntEn |= 0x80000000;
	VIC2IntEnClear =(unsigned long *)((char *) ptr_sft +0x1C);
	VIC2IntTrigger =(unsigned long *)((char *) ptr_sft +0x18);

	rt_enable_irq(63);//software interrupt enable

	rt_set_periodic_mode();/*let real time task periodic*/
	period[0] = 0;
	period[1]= start_rt_timer(nano2count(500000));


	rt_task_init(&mytask,rt_process, 0, 256, 0, 0, 0);

	rtf_create(0, sizeof(int)); //create fifo


return 0;

}

void cleanup_module(void){

	//releasing hardware interrupt
	rt_release_irq(63);
	*PBDR &= 0xFFFFFF1F;// turn off all the lights
	stop_rt_timer();	//stop timer
	rtf_destroy(0);
	rtf_destroy(1);
}

