///*
// * ctdb_tutorial1.c
// *
// * Public domain c-treeDB C example
// *
// * FairCom Corporation, 6300 West Sugar Creek Drive, Columbia, MO 65203 USA
// *
// * The goal of this tutorial is to introduce the most basic CTDB API
// * to accomplish creating and manipulating a table through the ctreeServer
// *
// * Functionally, this application will perform the following:
// *  1.  Logon onto a session
// *  2.  Add 1 table with some fields
// *  3.  Populate the table with a few records
// *  4.  Display the contents of the table
// */
//
//#ifdef _WIN32_WCE
//#undef UNICODE
//#undef _UNICODE
//#define main my_main
//#endif
//
//
///* Preprocessor definitions and includes */
//
//#include "ctdbsdk.h" /* c-tree headers */
//#include <stdio.h>
//
//#define END_OF_FILE INOT_ERR  /* INOT_ERR is ctree's 101 error. See cterrc.h */
//
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>
//#include <unistd.h>
//#include <sys/types.h>
//#include <sys/socket.h>
//#include <netinet/in.h>
//#include <netdb.h>
//#include <arpa/inet.h>
//#include <ifaddrs.h>
//
//#define MSG_SIZE 40			// message size
//
//void error(const char *msg)
//{
//    perror(msg);
//    exit(0);
//}
//
//
///* Global declarations */
//
//CTHANDLE hSession;
//CTHANDLE hDatabase;
//CTHANDLE hTable;
//CTHANDLE hRecord;
//
//
///* Function declarations */
//
//#ifdef PROTOTYPE
//VOID Initialize(VOID), Define(VOID), Manage(VOID), Done(VOID);
//VOID Add_Records(VOID), Display_Records(VOID);
//VOID Delete_Records(CTHANDLE), Check_Table_Mode(CTHANDLE);
//VOID Handle_Error(CTSTRING);
//#else
//VOID Initialize(), Define(), Manage(), Done();
//VOID Add_Records(), Display_Records();
//VOID Delete_Records(), Check_Table_Mode();
//VOID Handle_Error();
//#endif
//
//
///*
// * main()
// *
// * The main() function implements the concept of "init, define, manage
// * and you're done..."
// */
//
//#ifdef PROTOTYPE
//NINT main (NINT argc, pTEXT argv[])
//#else
//NINT main (argc, argv)
//NINT argc;
//TEXT argv[];
//#endif
//{
//
//
//
//
//	int sock, length, n;
//			int boolval = 1;			// for a socket option
//			socklen_t fromlen;
//			struct sockaddr_in server;
//			struct sockaddr_in addr;
//			char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
////			char s_buffer[MSG_SIZE];
////			char station_s[5],id_s[5],qty_s[5], ticket_s[5], transcation[5];
////			char *token_s;
//
//			 sock = socket(AF_INET, SOCK_DGRAM, 0); // Creates socket. Connectionless.
//					 if (sock < 0)
//					   error("Opening socket");
//					 length = sizeof(server);			// length of structure
//					 		 bzero(&server,length);			// sets all values to zero. memset() could be used
//
//					 		 server.sin_family = AF_INET;		// symbol constant for Internet domain
//					 		 server.sin_addr.s_addr = INADDR_ANY;		// IP address of the machine on which
//					 													// the server is running
//					 		 server.sin_port = htons(3000);	// using port 3000
//
//					 		 // binds the socket to the address of the host and the port number
//					 		 if (bind(sock, (struct sockaddr *)&server, length) < 0)
//					 			 error("binding");
//
//					 		 // change socket permissions to allow broadcast
//					 		 if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &boolval, sizeof(boolval)) < 0)
//					 		 {
//					 		   	printf("error setting socket options\n");
//					 		   	exit(-1);
//					 		 }
//
//					 		 fromlen = sizeof(struct sockaddr_in);	// size of structure
//					 		 while (1)
//					 			   {
//					 				   // to "clean up" the buffer. The messages aren't always the same length...
//					 				   bzero(&buffer,MSG_SIZE);
//
//					 				   // receive from a client
//					 				   n = recvfrom(sock, buffer, MSG_SIZE, 0, (struct sockaddr *)&addr, &fromlen);
//					 				   if (n < 0)
//					 				   	   error("recvfrom");
//					 			       printf("Received: %s", buffer);
//					 			   }
//
//Initialize();
//
//   Define();
//
//   Manage();
//
//   Done();
//
//   printf("\nPress <ENTER> key to exit . . .\n");
//#ifndef ctPortWINCE
//   getchar();
//#endif
//
//   return(0);
//}
//
//
///*
// * Initialize()
// *
// * Perform the minimum requirement of logging onto the c-tree Server
// */
//
//#ifdef PROTOTYPE
//VOID Initialize(VOID)
//#else
//VOID Initialize()
//#endif
//{
//   CTDBRET  retval;
//
//   printf("INIT\n");
//
//   if ((retval = ctdbStartDatabaseEngine())) 				/* This function is required when you are using the Server DLL model to start the underlying Server. */
//	Handle_Error("Initialize(): ctdbStartDatabaseEngine()"); 	/* It does nothing in all other c-tree models */
//
//   /* allocate session handle */
//   if ((hSession = ctdbAllocSession(CTSESSION_CTREE)) == NULL)
//      Handle_Error("Initialize(): ctdbAllocSession()");
//
//   hDatabase = hSession; /* database not used in this tutorial */
//
//   /* connect to server */
//   printf("\tLogon to server...\n");
//   if (ctdbLogon(hSession, "FAIRCOMS", "ADMIN", "ADMIN"))
//      Handle_Error("Initialize(): ctdbLogon()");
//}
//
//
///*
// * Define()
// *
// * Open the table, if it exists. Otherwise create and open the table
// */
//
//#ifdef PROTOTYPE
//VOID Define(VOID)
//#else
//VOID Define()
//#endif
//{
//   CTHANDLE hField1, hField2, hField3, hField4;
//
//
//   printf("DEFINE\n");
//
//   /* allocate a table handle */
//   if ((hTable = ctdbAllocTable(hDatabase)) == NULL)
//      Handle_Error("Define(); ctdbAllocTable()");
//
//   /* open table */
//   printf("\tOpen table...\n");
//   if (ctdbOpenTable(hTable, "custmast", CTOPEN_NORMAL))
//   {
//      /* define table fields */
//      printf("\tAdd fields...\n");
//      hField1 = ctdbAddField(hTable, "x", CT_FSTRING, 6);
//      hField2 = ctdbAddField(hTable, "y", CT_FSTRING, 4);
//      hField3 = ctdbAddField(hTable, "z", CT_FSTRING, 4);
//      hField4 = ctdbAddField(hTable, "result", CT_FSTRING, 1);
//
//      if (!hField1 || !hField2 || !hField3 || !hField4 )
//         Handle_Error("Define(); ctdbAddField()");
//
//      /* create table */
//      printf("\tCreate table...\n");
//      if (ctdbCreateTable(hTable, "custmast", CTCREATE_NORMAL))
//         Handle_Error("Define(); ctdbCreateTable()");
//
//      if (ctdbOpenTable(hTable, "custmast", CTOPEN_NORMAL))
//         Handle_Error("Define(); ctdbOpenTable()");
//   }
//   else
//      Check_Table_Mode(hTable);
//}
//
//
///*
// * Manage()
// *
// * This function performs simple record functions of add, delete and gets
// */
//
//#ifdef PROTOTYPE
//VOID Manage(VOID)
//#else
//VOID Manage()
//#endif
//{
//   printf("MANAGE\n");
//
//   /* allocate a record handle */
//   if ((hRecord = ctdbAllocRecord(hTable)) == NULL)
//      Handle_Error("Manage(): ctdbAllocRecord()");
//
//   /* delete any existing records */
//   Delete_Records(hRecord);
//
//   /* populate the table with data */
//   Add_Records();
//
//   /* display contents of table */
//   Display_Records();
//}
//
//
///*
// * Done()
// *
// * This function handles the housekeeping of closing tables and
// * freeing of associated memory
// */
//
//#ifdef PROTOTYPE
//VOID Done(VOID)
//#else
//VOID Done()
//#endif
//{
//   printf("DONE\n");
//
//   /* close table */
//   printf("\tClose table...\n");
//   if (ctdbCloseTable(hTable))
//      Handle_Error("Done(): ctdbCloseTable()");
//
//   /* logout */
//   printf("\tLogout...\n");
//   if (ctdbLogout(hSession))
//      Handle_Error("Done(): ctdbLogout()");
//
//   /* free handles */
//   ctdbFreeRecord(hRecord);
//   ctdbFreeTable(hTable);
//   ctdbFreeSession(hSession);
//
//   /* If you are linked to the Server DLL, then we should stop our Server at the end of the program.   */
//   /* It does nothing in all other c-tree models */
//   ctdbStopDatabaseEngine();
//}
//
//
///*
// * Check_Table_Mode()
// *
// * Check if existing table has transaction processing flag enabled.
// * If a table is under transaction processing control, modify the
// * table mode to disable transaction processing
// */
//
//#ifdef PROTOTYPE
//VOID Check_Table_Mode(CTHANDLE hTable)
//#else
//VOID Check_Table_Mode(hTable)
//CTHANDLE hTable;
//#endif
//{
//   CTCREATE_MODE mode;
//
//   /* get table create mode */
//   mode = ctdbGetTableCreateMode(hTable);
//
//   /* check if table is under transaction processing control */
//   if ((mode & CTCREATE_TRNLOG))
//   {
//      /* change file mode to disable transaction processing */
//      mode ^= CTCREATE_TRNLOG;
//      if (ctdbUpdateCreateMode(hTable, mode) != CTDBRET_OK)
//         Handle_Error("Check_Table_Mode(); ctdbUpdateCreateMode");
//   }
//}
//
//
///*
// * Delete_Records()
// *
// * This function deletes all the records in the table
// */
//
//#ifdef PROTOTYPE
//VOID Delete_Records(CTHANDLE hRecord)
//#else
//VOID Delete_Records(hRecord)
//CTHANDLE hRecord;
//#endif
//{
//   CTDBRET  retval;
//   CTBOOL   empty;
//
//   printf("\tDelete records...\n");
//
//   empty = NO;
//   retval = ctdbFirstRecord(hRecord);
//   if (retval != CTDBRET_OK)
//   {
//      if (retval == END_OF_FILE)
//         empty = YES;
//      else
//         Handle_Error("Delete_Records(): ctdbFirstRecord()");
//   }
//
//   while (empty == NO) /* while table is not empty */
//   {
//      /* delete record */
//      if (ctdbDeleteRecord(hRecord))
//         Handle_Error("Delete_Records(): ctdbDeleteRecord()");
//
//      /* read next record */
//      retval = ctdbNextRecord(hRecord);
//      if (retval != CTDBRET_OK)
//      {
//         if (retval == END_OF_FILE)
//            empty = YES;
//         else
//            Handle_Error("Delete_Records(): ctdbNextRecord()");
//      }
//   }
//}
//
//
///*
// * Add_Records()
// *
// * This function adds records to a table in the database from an
// * array of strings
// */
//
//typedef struct {
//   CTSTRING xacc, yacc, zacc, Fall;
//} CUSTOMER_DATA;
//
//CUSTOMER_DATA data[100000];
//int MAXsize = 100000;
//
///*
//CUSTOMER_DATA data[] = {
//   "1000", "92867", "CA", "1", "Bryan Williams", "2999 Regency",      "Orange",
//   "1001", "61434", "CT", "1", "Michael Jordan", "13 Main",           "Harford",
//   "1002", "73677", "GA", "1", "Joshua Brown",   "4356 Cambridge",    "Atlanta",
//   "1003", "10034", "MO", "1", "Keyon Dooling",  "19771 Park Avenue", "Columbia"
//};*/
//
////#ifdef PROTOTYPE
////VOID Add_Records(VOID)
////#else
////VOID Add_Records()
////#endif
////{
////   CTDBRET  retval;
////   CTSIGNED i;
////   CTSIGNED nRecords = sizeof(data) / sizeof(CUSTOMER_DATA);
////
////   printf("\tAdd records...\n");
////
////   /* add data to table */
////   for (i = 0; i < nRecords; i++)
////   {
////      /* clear record buffer */
////      ctdbClearRecord(hRecord);
////
////      retval = 0;
////      /* populate record buffer with data */
////      retval |= ctdbSetFieldAsString(hRecord, 0, data[i].xacc);
////      retval |= ctdbSetFieldAsString(hRecord, 1, data[i].yacc);
////      retval |= ctdbSetFieldAsString(hRecord, 2, data[i].zacc);
////      retval |= ctdbSetFieldAsString(hRecord, 3, data[i].Fall);
////
////      if (retval)
////         Handle_Error("Add_Records(): ctdbSetFieldAsString()");
////
////      /* add record */
////      if (ctdbWriteRecord(hRecord))
////         Handle_Error("Add_Records(): ctdbWriteRecord()");
////   }
////}
////
////
/////*
//// * Display_Records()
//// *
//// * This function displays the contents of a table. ctdbFirstRecord() and
//// * ctdbNextRecord() fetch the record. Then each field is parsed and displayed
//// */
////
////#ifdef PROTOTYPE
////VOID Display_Records(VOID)
////#else
////VOID Display_Records()
////#endif
////{
////   CTDBRET  retval;
////   TEXT     custnumb[4+1];
////   TEXT     custname[47+1];
////
////   printf("\tDisplay records...");
////
////   /* read first record */
////   retval = ctdbFirstRecord(hRecord);
////   if (retval != CTDBRET_OK)
////      Handle_Error("Display_Records(): ctdbFirstRecord()");
////
////   while (retval != END_OF_FILE)
////   {
////      retval = 0;
////      retval |= ctdbGetFieldAsString(hRecord, 0, custnumb, sizeof(custnumb));
////      retval |= ctdbGetFieldAsString(hRecord, 4, custname, sizeof(custname));
////      if (retval)
////         Handle_Error("Display_Records(): ctdbGetFieldAsString()");
////
////      printf("\n\t\t%-8s%10s\n",custnumb, custname);
////
////      /* read next record */
////      retval = ctdbNextRecord(hRecord);
////      if (retval == END_OF_FILE)
////         break;   /* reached end of file */
////
////      if (retval != CTDBRET_OK)
////         Handle_Error("Display_Records(): ctdbNextRecord()");
////   }
////}
////
////
/////*
//// * Handle_Error()
//// *
//// * This function is a common bailout routine. It displays an error message
//// * allowing the user to acknowledge before terminating the application
//// */
////
////#ifdef PROTOTYPE
////VOID Handle_Error(CTSTRING errmsg)
////#else
////VOID Handle_Error(errmsg)
////CTSTRING errmsg;
////#endif
////{
////   printf("\nERROR: [%d] - %s \n", ctdbGetError(hSession), errmsg);
////   printf("*** Execution aborted *** \nPress <ENTER> key to exit...");
////
////   ctdbLogout(hSession);
////
////   ctdbFreeRecord(hRecord);
////   ctdbFreeTable(hTable);
////   ctdbFreeSession(hSession);
////
////   getchar();
////
////   exit(1);
////}
////
/////* end of ctdb_tutorial3.c */
