/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.littlerobots.bean.BeanListener;
import nl.littlerobots.bean.internal.serial.GattSerialMessage;
import nl.littlerobots.bean.internal.serial.GattSerialTransport;
import nl.littlerobots.bean.message.Acceleration;
import nl.littlerobots.bean.message.Callback;
import nl.littlerobots.bean.message.Led;
import nl.littlerobots.bean.message.Message;
import nl.littlerobots.bean.message.RadioConfig;
import nl.littlerobots.bean.message.ScratchData;
import nl.littlerobots.bean.message.SketchMetaData;
import okio.Buffer;
import okio.Source;

public class Bean
implements Parcelable {
    public static final Parcelable.Creator<Bean> CREATOR = new Parcelable.Creator<Bean>(){

        public Bean createFromParcel(Parcel source) {
            BluetoothDevice device = (BluetoothDevice)source.readParcelable(this.getClass().getClassLoader());
            if (device == null) {
                throw new IllegalStateException("Device is null");
            }
            return new Bean(device);
        }

        public Bean[] newArray(int size) {
            return new Bean[size];
        }
    };
    private static final String TAG = "Bean";
    private BeanListener mInternalBeanListener;
    private BeanListener mBeanListener;
    private final GattSerialTransport.Listener mTransportListener;
    private final BluetoothDevice mDevice;
    private GattSerialTransport mTransport;
    private boolean mConnected;
    private HashMap<Integer, List<Callback<?>>> mCallbacks;
    private Handler mHandler;

    public Bean(BluetoothDevice device) {
        this.mBeanListener = this.mInternalBeanListener = new BeanListener(){

            @Override
            public void onConnected() {
                Log.w((String)Bean.TAG, (String)("onConnected after disconnect from device " + Bean.this.getDevice().getAddress()));
            }

            @Override
            public void onConnectionFailed() {
                Log.w((String)Bean.TAG, (String)("onConnectionFailed after disconnect from device " + Bean.this.getDevice().getAddress()));
            }

            @Override
            public void onDisconnected() {
                Log.w((String)Bean.TAG, (String)("onDisconnected after disconnect from device " + Bean.this.getDevice().getAddress()));
            }

            @Override
            public void onSerialMessageReceived(byte[] data) {
                Log.w((String)Bean.TAG, (String)("onSerialMessageReceived after disconnect from device " + Bean.this.getDevice().getAddress()));
            }

            @Override
            public void onScratchValueChanged(int bank, byte[] value) {
            }
        };
        this.mCallbacks = new HashMap(16);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mDevice = device;
        this.mTransportListener = new GattSerialTransport.Listener(){

            @Override
            public void onConnected() {
                Bean.this.mConnected = true;
                Bean.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Bean.this.mBeanListener.onConnected();
                    }
                });
            }

            @Override
            public void onConnectionFailed() {
                Bean.this.mConnected = false;
                Bean.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Bean.this.mBeanListener.onConnectionFailed();
                    }
                });
            }

            @Override
            public void onDisconnected() {
                Bean.this.mCallbacks.clear();
                Bean.this.mConnected = false;
                Bean.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Bean.this.mBeanListener.onDisconnected();
                    }
                });
            }

            @Override
            public void onMessageReceived(final byte[] data) {
                Bean.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Bean.this.handleMessage(data);
                    }
                });
            }

            @Override
            public void onScratchValueChanged(final int bank, final byte[] value) {
                Bean.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Bean.this.mBeanListener.onScratchValueChanged(bank, value);
                    }
                });
            }
        };
        this.mTransport = new GattSerialTransport(this.mTransportListener, device);
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public void connect(Context context, BeanListener listener) {
        if (this.mConnected) {
            return;
        }
        this.mBeanListener = listener;
        this.mTransport.connect(context);
    }

    public void disconnect() {
        this.mTransport.disconnect();
        this.mBeanListener = this.mInternalBeanListener;
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    public void readRadioConfig(Callback<RadioConfig> callback) {
        this.addCallback(1296, callback);
        this.sendMessageWithoutPayload(1296);
    }

    public void setLed(int r, int g, int b) {
        Buffer buffer = new Buffer();
        buffer.writeByte(r);
        buffer.writeByte(g);
        buffer.writeByte(b);
        this.sendMessage(8193, buffer);
    }

    public void readLed(Callback<Led> callback) {
        this.addCallback(8194, callback);
        this.sendMessageWithoutPayload(8194);
    }

    public void setAdvertising(boolean enable) {
        Buffer buffer = new Buffer();
        buffer.writeByte(enable ? 1 : 0);
        this.sendMessage(1298, buffer);
    }

    public void readTemperature(Callback<Integer> callback) {
        this.addCallback(8209, callback);
        this.sendMessageWithoutPayload(8209);
    }

    public void readAcceleration(Callback<Acceleration> callback) {
        this.addCallback(8208, callback);
        this.sendMessageWithoutPayload(8208);
    }

    public void readSketchMetaData(Callback<SketchMetaData> callback) {
        this.addCallback(4099, callback);
        this.sendMessageWithoutPayload(4099);
    }

    public void readScratchData(int number, Callback<ScratchData> callback) {
        this.addCallback(1301, callback);
        Buffer buffer = new Buffer();
        if (number < 0 || number > 5) {
            throw new IllegalArgumentException("Scratch bank must be in the range of 0-4");
        }
        buffer.writeByte(number + 1 & 0xFF);
        this.sendMessage(1301, buffer);
    }

    public void setScratchData(int number, byte[] data) {
        ScratchData sd = ScratchData.create(number, data);
        this.sendMessage(1300, sd);
    }

    public void setScratchData(int number, String data) {
        ScratchData sd = ScratchData.create(number, data);
        this.sendMessage(1300, sd);
    }

    public void setRadioConfig(RadioConfig config) {
        this.sendMessage(1297, config);
    }

    public void sendSerialMessage(byte[] value) {
        Buffer buffer = new Buffer();
        buffer.write(value);
        this.sendMessage(0, buffer);
    }

    public void sendSerialMessage(String value) {
        Buffer buffer = new Buffer();
        try {
            buffer.write(value.getBytes("UTF-8"));
            this.sendMessage(0, buffer);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMessage(byte[] data) {
        Buffer buffer = new Buffer();
        buffer.write(data);
        int type = buffer.readShort() & 0xFFFF & 0xFFFFFF7F;
        switch (type) {
            case 0: {
                this.mBeanListener.onSerialMessageReceived(buffer.readByteArray());
                break;
            }
            case 1296: {
                this.returnConfig(buffer);
                break;
            }
            case 8209: {
                this.returnTemperature(buffer);
                break;
            }
            case 4099: {
                this.returnMetaData(buffer);
                break;
            }
            case 1301: {
                this.returnScratchData(buffer);
                break;
            }
            case 8194: {
                this.returnLed(buffer);
                break;
            }
            case 8208: {
                this.returnAcceleration(buffer);
                break;
            }
            case 8192: {
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Received message of unknown type " + Integer.toHexString(type)));
                this.disconnect();
            }
        }
    }

    private void returnAcceleration(Buffer buffer) {
        Callback<Acceleration> callback = this.getFirstCallback(8208);
        if (callback != null) {
            callback.onResult(Acceleration.fromPayload(buffer));
        }
    }

    private void returnLed(Buffer buffer) {
        Callback<Led> callback = this.getFirstCallback(8194);
        if (callback != null) {
            callback.onResult(Led.fromPayload(buffer));
        }
    }

    private void returnScratchData(Buffer buffer) {
        Callback<ScratchData> callback = this.getFirstCallback(1301);
        if (callback != null) {
            callback.onResult(ScratchData.fromPayload(buffer));
        }
    }

    private void returnMetaData(Buffer buffer) {
        Callback<SketchMetaData> callback = this.getFirstCallback(4099);
        if (callback != null) {
            callback.onResult(SketchMetaData.fromPayload(buffer));
        }
    }

    private void returnTemperature(Buffer buffer) {
        Callback<Integer> callback = this.getFirstCallback(8209);
        if (callback != null) {
            callback.onResult(Integer.valueOf(buffer.readByte()));
        }
    }

    private void returnConfig(Buffer data) {
        RadioConfig config = RadioConfig.fromPayload(data);
        Callback<RadioConfig> callback = this.getFirstCallback(1296);
        if (callback != null) {
            callback.onResult(config);
        }
    }

    private void addCallback(int type, Callback<?> callback) {
        List<Callback<?>> callbacks = this.mCallbacks.get(type);
        if (callbacks == null) {
            callbacks = new ArrayList(16);
            this.mCallbacks.put(type, callbacks);
        }
        callbacks.add(callback);
    }

    private <T> Callback<T> getFirstCallback(int type) {
        List<Callback<?>> callbacks = this.mCallbacks.get(type);
        if (callbacks == null || callbacks.isEmpty()) {
            Log.w((String)TAG, (String)"Got response without callback!");
            return null;
        }
        return callbacks.remove(0);
    }

    private void sendMessage(int type, Message message) {
        Buffer buffer = new Buffer();
        buffer.writeByte(type >> 8 & 0xFF);
        buffer.writeByte(type & 0xFF);
        buffer.write(message.toPayload());
        GattSerialMessage serialMessage = GattSerialMessage.fromPayload(buffer.readByteArray());
        this.mTransport.sendMessage(serialMessage.getBuffer());
    }

    private void sendMessage(int type, Buffer payload) {
        Buffer buffer = new Buffer();
        buffer.writeByte(type >> 8 & 0xFF);
        buffer.writeByte(type & 0xFF);
        if (payload != null) {
            try {
                buffer.writeAll((Source)payload);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        GattSerialMessage serialMessage = GattSerialMessage.fromPayload(buffer.readByteArray());
        this.mTransport.sendMessage(serialMessage.getBuffer());
    }

    private void sendMessageWithoutPayload(int type) {
        this.sendMessage(type, (Buffer)null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mDevice, 0);
    }
}

