/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import nl.littlerobots.bean.Bean;
import nl.littlerobots.bean.BeanDiscoveryListener;

public class BeanManager {
    private static final String TAG = "BeanManager";
    private static final UUID BEAN_UUID = UUID.fromString("a495ff10-c5b1-4b44-b512-1370f02d74de");
    private static final long SCAN_TIMEOUT = 30000L;
    private static BeanManager sInstance = new BeanManager();
    private Handler mHandler = new Handler();
    private BeanDiscoveryListener mListener;
    private boolean mScanning = false;
    private Runnable mCompleteDiscoveryCallback = new Runnable(){

        @Override
        public void run() {
            BeanManager.this.completeDiscovery();
        }
    };
    private final BluetoothAdapter.LeScanCallback mCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            if (!BeanManager.this.mBeans.containsKey(device.getAddress())) {
                BeanManager.this.mHandler.removeCallbacks(BeanManager.this.mCompleteDiscoveryCallback);
                List uuids = BeanManager.this.parseUUIDs(scanRecord);
                if (uuids.contains(BEAN_UUID)) {
                    final Bean bean = new Bean(device);
                    BeanManager.this.mBeans.put(device.getAddress(), bean);
                    BeanManager.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BeanManager.this.mListener.onBeanDiscovered(bean);
                        }
                    });
                }
                BeanManager.this.mHandler.postDelayed(BeanManager.this.mCompleteDiscoveryCallback, 15000L);
            }
        }
    };
    private HashMap<String, Bean> mBeans = new HashMap(32);

    private BeanManager() {
    }

    public static BeanManager getInstance() {
        return sInstance;
    }

    public boolean startDiscovery(BeanDiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null");
        }
        if (this.mScanning) {
            this.cancelDiscovery();
        }
        this.mBeans.clear();
        this.mListener = listener;
        this.mScanning = true;
        if (BluetoothAdapter.getDefaultAdapter().startLeScan(this.mCallback)) {
            this.mHandler.postDelayed(this.mCompleteDiscoveryCallback, 30000L);
            return true;
        }
        return false;
    }

    public void cancelDiscovery() {
        if (this.mScanning) {
            BluetoothAdapter.getDefaultAdapter().stopLeScan(this.mCallback);
            this.mScanning = false;
        }
    }

    public Collection<Bean> getBeans() {
        return new ArrayList<Bean>(this.mBeans.values());
    }

    private void completeDiscovery() {
        if (this.mScanning) {
            BluetoothAdapter.getDefaultAdapter().stopLeScan(this.mCallback);
            this.mScanning = false;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BeanManager.this.mListener.onDiscoveryComplete();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UUID> parseUUIDs(byte[] advertisedData) {
        int len;
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        int offset = 0;
        block7: while (offset < advertisedData.length - 2 && (len = advertisedData[offset++]) != 0) {
            byte type = advertisedData[offset++];
            switch (type) {
                case 2: 
                case 3: {
                    while (len > 1) {
                        int uuid16 = advertisedData[offset++];
                        int n = offset++;
                        len -= 2;
                        uuids.add(UUID.fromString(String.format("%08x-0000-1000-8000-00805f9b34fb", uuid16 += advertisedData[n] << 8)));
                    }
                    continue block7;
                }
                case 6: 
                case 7: {
                    while (len >= 16) {
                        try {
                            ByteBuffer buffer = ByteBuffer.wrap(advertisedData, offset++, 16).order(ByteOrder.LITTLE_ENDIAN);
                            long mostSignificantBit = buffer.getLong();
                            long leastSignificantBit = buffer.getLong();
                            uuids.add(new UUID(leastSignificantBit, mostSignificantBit));
                        }
                        finally {
                            offset += 15;
                            len -= 16;
                        }
                    }
                    continue block7;
                }
            }
            offset += len - 1;
        }
        return uuids;
    }
}

