/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.internal.serial;

import android.util.Log;
import okio.Buffer;

public class GattSerialMessage {
    private static final String TAG = "GattSerialMessage";
    private final Buffer mBuffer;

    private GattSerialMessage(Buffer buffer) {
        this.mBuffer = buffer;
    }

    public static GattSerialMessage fromPayload(byte[] payload) {
        Buffer buffer = new Buffer();
        byte[] header = new byte[]{(byte)(payload.length & 0xFF), 0};
        int crc = GattSerialMessage.computeCRC16(header, 0, header.length);
        crc = GattSerialMessage.computeCRC16(crc, payload, 0, payload.length);
        buffer.write(header);
        buffer.write(payload);
        buffer.writeByte(crc & 0xFF);
        buffer.writeByte(crc >> 8 & 0xFF);
        return new GattSerialMessage(buffer);
    }

    public static byte[] parse(byte[] payload) {
        int length = payload[0] & 0xFF;
        Buffer buffer = new Buffer();
        buffer.write(payload, 2, length);
        int crc = GattSerialMessage.computeCRC16(payload, 0, payload.length - 2);
        int checkCrc = ((payload[payload.length - 1] & 0xFF) << 8) + (payload[payload.length - 2] & 0xFF);
        if (crc != checkCrc) {
            Log.w((String)TAG, (String)"Checksum failed");
            throw new IllegalStateException("Checksum mismatch");
        }
        return buffer.readByteArray();
    }

    static int computeCRC16(byte[] data, int offset, int length) {
        return GattSerialMessage.computeCRC16(65535, data, offset, length);
    }

    static int computeCRC16(int startingCrc, byte[] data, int offset, int length) {
        int crc = startingCrc & 0xFFFF;
        for (int i = offset; i < offset + length; ++i) {
            crc = crc >> 8 & 0xFFFF | crc << 8 & 0xFFFF;
            crc ^= data[i] & 0xFF;
            crc &= 0xFFFF;
            crc ^= (crc & 0xFF) >> 4;
            crc &= 0xFFFF;
            crc ^= crc << 8 << 4;
            crc &= 0xFFFF;
            crc ^= (crc & 0xFF) << 4 << 1;
            crc &= 0xFFFF;
        }
        return crc & 0xFFFF;
    }

    public Buffer getBuffer() {
        return this.mBuffer;
    }
}

