/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.internal.serial;

import java.io.IOException;
import okio.Buffer;

public class GattSerialPacket {
    private final boolean mFirstPacket;
    private final int mMessageCount;
    private final int mPendingCount;
    private byte[] mPacket;

    public GattSerialPacket(boolean startBit, int outgoingMessageCount, int pendingPacketCount, Buffer message) {
        this.mFirstPacket = startBit;
        this.mMessageCount = outgoingMessageCount;
        this.mPendingCount = pendingPacketCount;
        Buffer buffer = new Buffer();
        buffer.writeByte((startBit ? 128 : 0) | outgoingMessageCount << 5 & 0x60 | pendingPacketCount & 0x1F);
        int size = (int)Math.min(19L, message.size());
        try {
            message.readFully(buffer, (long)size);
            this.mPacket = buffer.readByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GattSerialPacket(byte[] data) {
        this.mFirstPacket = (data[0] & 0x80) == 128;
        this.mMessageCount = (data[0] & 0x60) >> 5;
        this.mPendingCount = data[0] & 0x1F;
        this.mPacket = data;
    }

    public byte[] getPacketData() {
        return this.mPacket;
    }

    public boolean isFirstPacket() {
        return this.mFirstPacket;
    }

    public int getMessageCount() {
        return this.mMessageCount;
    }

    public int getPendingCount() {
        return this.mPendingCount;
    }

    public Buffer getPayload() {
        Buffer buffer = new Buffer();
        buffer.write(this.mPacket, 1, this.mPacket.length - 1);
        return buffer;
    }

    public boolean hasPayload() {
        return this.mPacket.length > 1;
    }
}

