/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.internal.serial;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import nl.littlerobots.bean.internal.serial.GattSerialPacket;
import nl.littlerobots.bean.internal.serial.MessageAssembler;
import okio.Buffer;

public class GattSerialTransport {
    public static final int PACKET_TX_MAX_PAYLOAD_LENGTH = 19;
    private static final UUID BEAN_SERIAL_CHARACTERISTIC_UUID = UUID.fromString("a495ff11-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SERIAL_SERVICE_UUID = UUID.fromString("a495ff10-c5b1-4b44-b512-1370f02d74de");
    private static final String TAG = "GattSerialTransport";
    private static final UUID BEAN_SCRATCH_SERVICE_UUID = UUID.fromString("a495ff20-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SCRATCH_0_UUID = UUID.fromString("a495ff21-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SCRATCH_1_UUID = UUID.fromString("a495ff22-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SCRATCH_2_UUID = UUID.fromString("a495ff23-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SCRATCH_3_UUID = UUID.fromString("a495ff24-c5b1-4b44-b512-1370f02d74de");
    private static final UUID BEAN_SCRATCH_4_UUID = UUID.fromString("a495ff25-c5b1-4b44-b512-1370f02d74de");
    private static final List<UUID> BEAN_SCRATCH_UUIDS = Arrays.asList(BEAN_SCRATCH_0_UUID, BEAN_SCRATCH_1_UUID, BEAN_SCRATCH_2_UUID, BEAN_SCRATCH_3_UUID, BEAN_SCRATCH_4_UUID);
    private final BluetoothDevice mDevice;
    private WeakReference<Listener> mListener = new WeakReference<Object>(null);
    private BluetoothGatt mGatt;
    private BluetoothGattCharacteristic mSerialCharacteristic;
    private boolean mReadyToSend = false;
    private final Runnable mDequeueRunnable = new Runnable(){

        @Override
        public void run() {
            if (!GattSerialTransport.this.mPendingPackets.isEmpty()) {
                if (GattSerialTransport.this.mReadyToSend && GattSerialTransport.this.mSerialCharacteristic != null && GattSerialTransport.this.mGatt != null) {
                    GattSerialTransport.this.mReadyToSend = false;
                    GattSerialPacket packet = (GattSerialPacket)GattSerialTransport.this.mPendingPackets.remove(0);
                    GattSerialTransport.this.mSerialCharacteristic.setValue(packet.getPacketData());
                    GattSerialTransport.this.mGatt.writeCharacteristic(GattSerialTransport.this.mSerialCharacteristic);
                }
                GattSerialTransport.this.mHandler.postDelayed((Runnable)this, 150L);
            }
        }
    };
    private List<GattSerialPacket> mPendingPackets = new ArrayList<GattSerialPacket>(32);
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private int mOutgoingMessageCount = 0;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (status != 0) {
                Log.w((String)GattSerialTransport.TAG, (String)"Non success state, disconnecting");
                GattSerialTransport.this.abort();
            } else if (newState == 2) {
                GattSerialTransport.this.discoverServices();
            } else if (newState == 0) {
                GattSerialTransport.this.abort();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            if (status != 0) {
                Log.w((String)GattSerialTransport.TAG, (String)"Non success state, disconnecting");
                GattSerialTransport.this.abort();
            } else {
                BluetoothGattService service = gatt.getService(BEAN_SERIAL_SERVICE_UUID);
                GattSerialTransport.this.mSerialCharacteristic = service.getCharacteristic(BEAN_SERIAL_CHARACTERISTIC_UUID);
                if (GattSerialTransport.this.mSerialCharacteristic == null) {
                    Log.w((String)GattSerialTransport.TAG, (String)"Did not find bean serial on device, disconnecting");
                    GattSerialTransport.this.abort();
                } else {
                    GattSerialTransport.this.mGatt.setCharacteristicNotification(GattSerialTransport.this.mSerialCharacteristic, true);
                    for (BluetoothGattDescriptor descriptor : GattSerialTransport.this.mSerialCharacteristic.getDescriptors()) {
                        if (descriptor.getUuid().getMostSignificantBits() >> 32 != 10498L) continue;
                        descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                        gatt.writeDescriptor(descriptor);
                    }
                    service = gatt.getService(BEAN_SCRATCH_SERVICE_UUID);
                    for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                        gatt.setCharacteristicNotification(characteristic, true);
                        for (BluetoothGattDescriptor descriptor : characteristic.getDescriptors()) {
                            if (descriptor.getUuid().getMostSignificantBits() >> 32 != 10498L) continue;
                            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            gatt.writeDescriptor(descriptor);
                        }
                    }
                }
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            if (status != 0) {
                Log.w((String)GattSerialTransport.TAG, (String)"Write characteristic failed, disconnecting");
                GattSerialTransport.this.abort();
            } else {
                GattSerialTransport.this.mHandler.removeCallbacks(GattSerialTransport.this.mDequeueRunnable);
                GattSerialTransport.this.mReadyToSend = true;
                GattSerialTransport.this.mHandler.post(GattSerialTransport.this.mDequeueRunnable);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            if (characteristic == GattSerialTransport.this.mSerialCharacteristic) {
                byte[] data = GattSerialTransport.this.mMessageAssembler.assemble(new GattSerialPacket(characteristic.getValue()));
                if (data != null) {
                    Listener listener = (Listener)GattSerialTransport.this.mListener.get();
                    if (listener != null) {
                        listener.onMessageReceived(data);
                    } else {
                        GattSerialTransport.this.disconnect();
                    }
                }
            } else {
                int index = BEAN_SCRATCH_UUIDS.indexOf(characteristic.getUuid());
                if (index > -1) {
                    Listener listener = (Listener)GattSerialTransport.this.mListener.get();
                    if (listener != null) {
                        listener.onScratchValueChanged(index, characteristic.getValue());
                    } else {
                        GattSerialTransport.this.disconnect();
                    }
                }
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            if (Arrays.equals(descriptor.getValue(), BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) && descriptor.getCharacteristic() == GattSerialTransport.this.mSerialCharacteristic) {
                if (status != 0) {
                    GattSerialTransport.this.abort();
                } else {
                    GattSerialTransport.this.mReadyToSend = true;
                    GattSerialTransport.this.mOutgoingMessageCount = 0;
                    Listener listener = (Listener)GattSerialTransport.this.mListener.get();
                    if (listener != null) {
                        listener.onConnected();
                    } else {
                        Log.e((String)GattSerialTransport.TAG, (String)"No listener, this must be a stale connection --> disconnect");
                        GattSerialTransport.this.disconnect();
                    }
                }
            }
        }
    };
    private MessageAssembler mMessageAssembler = new MessageAssembler();

    public GattSerialTransport(Listener listener, BluetoothDevice device) {
        this.mDevice = device;
        this.mListener = new WeakReference<Listener>(listener);
    }

    private void logWritten(byte[] value) {
        StringBuilder sb = new StringBuilder();
        for (byte b : value) {
            sb.append(Integer.toHexString(b & 0xFF));
            sb.append(" ");
        }
        Log.d((String)TAG, (String)("Write: " + sb.toString()));
    }

    private void discoverServices() {
        this.mGatt.discoverServices();
    }

    public void connect(Context context) {
        if (this.mGatt != null) {
            Listener listener = (Listener)this.mListener.get();
            if (listener != null) {
                listener.onConnected();
            } else {
                this.disconnect();
            }
        } else {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mPendingPackets.clear();
            this.mGatt = this.mDevice.connectGatt(context, false, this.mGattCallback);
        }
    }

    private void abort() {
        boolean wasConnected = this.mSerialCharacteristic != null;
        this.disconnect();
        Listener listener = (Listener)this.mListener.get();
        if (listener != null) {
            if (wasConnected) {
                listener.onDisconnected();
            } else {
                listener.onConnectionFailed();
            }
        }
    }

    public void disconnect() {
        this.mReadyToSend = false;
        this.mPendingPackets.clear();
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mGatt != null) {
            this.mGatt.close();
        }
        this.mSerialCharacteristic = null;
        this.mGatt = null;
    }

    public void sendMessage(Buffer message) {
        if (this.mGatt == null) {
            throw new IllegalStateException("Not connected");
        }
        int packets = (int)(message.size() / 19L);
        this.mOutgoingMessageCount = (this.mOutgoingMessageCount + 1) % 4;
        int size = (int)message.size();
        for (int i = 0; i < size; i += 19) {
            GattSerialPacket packet = new GattSerialPacket(i == 0, this.mOutgoingMessageCount, packets--, message);
            this.mPendingPackets.add(packet);
        }
        this.mHandler.post(this.mDequeueRunnable);
    }

    public static interface Listener {
        public void onConnected();

        public void onConnectionFailed();

        public void onDisconnected();

        public void onMessageReceived(byte[] var1);

        public void onScratchValueChanged(int var1, byte[] var2);
    }
}

