/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.internal.serial;

import android.util.Log;
import java.io.IOException;
import nl.littlerobots.bean.internal.serial.GattSerialMessage;
import nl.littlerobots.bean.internal.serial.GattSerialPacket;
import okio.Buffer;
import okio.Source;

public class MessageAssembler {
    private static final String TAG = "MessageAssembler";
    private Buffer mBuffer = new Buffer();
    private int mMessageIndex;
    private boolean mFirstPacket = true;
    private int mPacketIndex;

    public byte[] assemble(GattSerialPacket packet) {
        Log.d((String)TAG, (String)("assemble: First packet = " + packet.isFirstPacket() + ", index = " + packet.getMessageCount() + " pending = " + packet.getPendingCount()));
        if (packet.isFirstPacket()) {
            if (this.mFirstPacket) {
                this.mFirstPacket = false;
            } else if (packet.getMessageCount() != ++this.mMessageIndex % 4) {
                Log.w((String)TAG, (String)("Message count is out of sequence " + packet.getMessageCount() + " vs " + this.mMessageIndex));
            }
            this.mMessageIndex = packet.getMessageCount();
            this.mPacketIndex = packet.getPendingCount();
        } else {
            if (packet.getMessageCount() != this.mMessageIndex) {
                throw new IllegalStateException("Unexpected message count " + packet.getMessageCount() + ", expected " + this.mMessageIndex);
            }
            --this.mPacketIndex;
            if (packet.getPendingCount() != this.mPacketIndex) {
                throw new IllegalStateException("Unexpected pending count " + packet.getPendingCount() + ", expected " + this.mPacketIndex);
            }
        }
        if (packet.isFirstPacket() && this.mBuffer.size() > 0L) {
            throw new IllegalStateException("Received first packet while trying to assemble previous packets");
        }
        if (!packet.isFirstPacket() && this.mBuffer.size() == 0L) {
            throw new IllegalStateException("Received non start packet without any data");
        }
        this.writeToBuffer(packet.getPayload());
        if (packet.getPendingCount() == 0) {
            return GattSerialMessage.parse(this.mBuffer.readByteArray());
        }
        return null;
    }

    private void writeToBuffer(Buffer source) {
        try {
            this.mBuffer.writeAll((Source)source);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

