/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.message;

import android.os.Parcelable;
import android.text.TextUtils;
import java.nio.charset.Charset;
import nl.littlerobots.bean.message.AutoParcel_RadioConfig;
import nl.littlerobots.bean.message.Message;
import okio.Buffer;

public abstract class RadioConfig
implements Parcelable,
Message {
    public static RadioConfig create(String name, int advertisementInterval, int connectionInterval, TxPower power, AdvertisementMode mode, int beaconUuid, int beaconMajor, int beaconMinor) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        if (name.length() > 20) {
            throw new IllegalArgumentException("Name must be max 20 characters");
        }
        return new AutoParcel_RadioConfig(name, advertisementInterval, connectionInterval, power, mode, beaconUuid, beaconMajor, beaconMinor);
    }

    public static RadioConfig fromPayload(Buffer buffer) {
        int advertisementInterval = buffer.readShortLe() & 0xFFFF;
        int connectionInterval = buffer.readShortLe() & 0xFFFF;
        int power = buffer.readByte() & 0xFF;
        int mode = buffer.readByte() & 0xFF;
        int beaconUuid = buffer.readShortLe() & 0xFFFF;
        int beaconMajor = buffer.readShortLe() & 0xFFFF;
        int beaconMinor = buffer.readShortLe() & 0xFFFF;
        String localName = buffer.readString(buffer.size() - 1L, Charset.forName("UTF-8"));
        int size = buffer.readByte() & 0xFF;
        localName = localName.substring(0, size);
        return new AutoParcel_RadioConfig(localName, advertisementInterval, connectionInterval, TxPower.values()[power], AdvertisementMode.values()[mode], beaconUuid, beaconMajor, beaconMinor);
    }

    public abstract String name();

    public abstract int advertisementInterval();

    public abstract int connectionInterval();

    public abstract TxPower power();

    public abstract AdvertisementMode advertisementMode();

    public abstract int beaconUuid();

    public abstract int beaconMajor();

    public abstract int beaconMinor();

    @Override
    public byte[] toPayload() {
        Buffer buffer = new Buffer();
        buffer.writeShortLe(this.advertisementInterval() & 0xFFFF);
        buffer.writeShortLe(this.connectionInterval() & 0xFFFF);
        buffer.writeByte(this.power().ordinal() & 0xFF);
        buffer.writeByte(this.advertisementMode().ordinal() & 0xFF);
        buffer.writeShortLe(this.beaconUuid() & 0xFFFF);
        buffer.writeShortLe(this.beaconMajor() & 0xFFFF);
        buffer.writeShortLe(this.beaconMinor() & 0xFFFF);
        StringBuilder sb = new StringBuilder(this.name());
        sb.setLength(20);
        buffer.writeString(sb.toString(), Charset.forName("UTF-8"));
        buffer.writeByte(this.name().length() & 0xFF);
        return buffer.readByteArray();
    }

    public static enum AdvertisementMode {
        STANDARD,
        IBEACON;

    }

    public static enum TxPower {
        TX_NEG23DB,
        TX_NEG6DB,
        TX_0DB,
        TX_4DB;

    }
}

