/*
 * Decompiled with CFR 0.152.
 */
package nl.littlerobots.bean.message;

import android.os.Parcelable;
import java.io.UnsupportedEncodingException;
import nl.littlerobots.bean.message.AutoParcel_ScratchData;
import nl.littlerobots.bean.message.Message;
import okio.Buffer;

public abstract class ScratchData
implements Parcelable,
Message {
    public static ScratchData fromPayload(Buffer buffer) {
        return new AutoParcel_ScratchData((buffer.readByte() & 0xFF) - 1, buffer.readByteArray());
    }

    public static ScratchData create(int number, byte[] data) {
        if (number < 0 || number > 4) {
            throw new IllegalArgumentException("Scratch number needs to be 0 - 4");
        }
        return new AutoParcel_ScratchData(number, data);
    }

    public static ScratchData create(int number, String data) {
        try {
            return ScratchData.create(number, data == null ? new byte[]{} : data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract int number();

    public abstract byte[] data();

    public String getDataAsString() {
        try {
            return new String(this.data(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toPayload() {
        Buffer buffer = new Buffer();
        buffer.writeByte(this.number() + 1 & 0xFF);
        buffer.write(this.data());
        return buffer.readByteArray();
    }
}

