package net.quarkworks.bluetoothlightcontrol;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.util.Log;

/**
 * Created by benjamin on 5/3/15.
 * Class for sending a broadcast udp packet
 */
public class UDPBroadcast extends AsyncTask<byte[], byte[], Void> {
    private static final String TAG = UDPBroadcast.class.getSimpleName();

    /*
        References
     */
    private Context context;
    private DatagramSocket socket;

    /*
        Data
     */
	private int port;

    UDPBroadcast(Context context, int port) {
        this.context=context;
        this.port=port;
	}

    //Send message function
    public void sendMessage(String text){
        byte[] dataArray = text.getBytes();
        this.execute(dataArray);
    }

	protected Void doInBackground(byte[]... dataArray) {
		try {
			socket = new DatagramSocket();
			Log.d(TAG, "doInBackground: Socket created, maximum Buffer size:" + socket.getSendBufferSize() + " bytes");
		}
        catch (SocketException e) {
			e.printStackTrace();
			Log.d(TAG, "broken socket");
		}

		byte[] data = dataArray[0];
		Log.d(TAG, "Data size: " + data.length);

		try {
			// Fragment the data into small chunks and send them sequentially
			int num_packets = (int) Math.ceil(data.length / 1024.0);
			Log.d(TAG, "Sending " + num_packets + " packets");
			byte[] tmp = new byte[1024];

			for (int i = 0; i < num_packets; i++) {
				// The last packet might be smaller
				if (i == num_packets - 1)
					System.arraycopy(data, i * 1024, tmp, 0, (data.length - i * 1024) % 1024);
				else
					System.arraycopy(data, i * 1024, tmp, 0, 1024);

                //Send packet via with broadcast address
				DatagramPacket packet = new DatagramPacket(tmp, tmp.length, getBroadcastAddress(context), port);
				socket.send(packet);
				Log.d(TAG, "Sent packet: " + i);
			}
			return null;
		}
        catch (UnknownHostException e) {
			Log.d(TAG, "Unknown Host");
			e.printStackTrace();
		}
        catch (IOException e) {
			Log.d(TAG, "IO Exception");
			e.printStackTrace();
        }
        finally {
			try {
				socket.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
			Log.d(TAG, "doInBackground: Finished");
		}
		return null;
	}

	protected void onProgressUpdate(byte[]... values) {
		byte[] data = values[0];
		String str;
		try {
			str = new String(data, "UTF8");
			Log.d(TAG, str);
			// appendToOutput(str);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
	}

	@Override
	protected void onCancelled() {
		Log.d(TAG, "Cancelled.");
	}

	protected void onPostExecute(Void v) {
		Log.d(TAG, "onPostExecute");
	}

    //Get broadcast address (xxx.xxx.xxx.255)
    InetAddress getBroadcastAddress(Context context) throws IOException {
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        DhcpInfo dhcp = wifi.getDhcpInfo();

        if (dhcp == null){
            throw new IOException("Not connected to wifi");
        }

        int broadcast = (dhcp.ipAddress & dhcp.netmask) | ~dhcp.netmask;
        byte[] quads = new byte[4];
        for (int k = 0; k < 4; k++)
            quads[k] = (byte) ((broadcast >> k * 8) & 0xFF);
        return InetAddress.getByAddress(quads);
    }

}