#include <stdio.h>
#include <unistd.h>
#include <string.h> 
#include <time.h>
#include <stdlib.h>
#include <time.h>
#include <inttypes.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>

#include <wiringPi.h>
#include <wiringPiSPI.h>

//Max message size
#define MSG_SIZE 40

int currentVote = 0;
int currentIp = 0;
int currentMasterIp = 0;
char* address;

void sendSPIMessage(char[MSG_SIZE]);

//Initialization to get current address
void getAddress(){
    int sckt;
    struct ifreq ifr;

    //Create a socket so we can pull our IP information out
    sckt = socket(AF_INET, SOCK_DGRAM, 0);
    if (sckt < 0){
        printf("Error opening socket");
        exit(0);
    }

    ifr.ifr_addr.sa_family = AF_INET;

    //Using the default interface eth0
    strncpy(ifr.ifr_name, "wlan0", IFNAMSIZ-1);

    ioctl(sckt, SIOCGIFADDR, &ifr);

    //Copy the current address into a character array. 
    address = inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr);

    //Split up address by periods so that we can save the last set of numbers as our current ip integer for comparison purposes.
    char ipBuffer[20];
    bzero(ipBuffer, 20);
    strcpy(ipBuffer,address);

    //printf("ipBuffer: %s\n",ipBuffer);

    char** ip = NULL;
    char* block = strtok (ipBuffer, ".");
    int n_periods = 0, i;

    while (block) {
        ip = realloc (ip, sizeof (char*) * ++n_periods);

        ip[n_periods-1] = block;

        block = strtok (NULL, ".");
    }

    ip = realloc (ip, sizeof (char*) * (n_periods+1));
    ip[n_periods] = 0;

    //Check to make sure valid input
    if (n_periods != 4){
        printf("Invalid ip address");
    }
    else {
        currentIp = atoi(ip[3]);
    }

    printf("%s\n", address);

    close(sckt);

    // -------------------------------------
}

int main(int argc, char *argv[]){
	int port = 0;

    // Use arg 1 as current port if available, otherwise default to 5000
	if (argc < 2){
		port = 5000;
	}
	else {
		port = atoi(argv[1]);
	}

    srand(time(NULL));

    //Initialization to get current address
    getAddress();

    //Wiring Pi Setup
	wiringPiSetup();
	wiringPiSPISetup(1, 614400);
	pinMode(7,OUTPUT);
	digitalWrite(7,1);

    //Setup sockets for sending and receiving messages
    int serverLength;
    int boolVal = 1;
    socklen_t fromlen;
    struct sockaddr_in server;
    struct sockaddr_in anybody;

    serverLength = sizeof(server);
    bzero(&server,serverLength);
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(port);

    int sckt = socket(AF_INET, SOCK_DGRAM, 0);
    if (sckt < 0){
        printf("Error opening socket\n");
        exit(0);
    }

    if (bind(sckt, (struct sockaddr*)&server, serverLength) < 0){
        printf("Error binding to socket\n");
        exit(0);
    }

    if (setsockopt(sckt, SOL_SOCKET, SO_BROADCAST, &boolVal, sizeof(boolVal)) < 0){
        printf("error setting socket options\n");
        exit(-1);
    }

    anybody.sin_family = AF_INET;		// symbol constant for Internet domain
    anybody.sin_port = htons(port);				// port field
    anybody.sin_addr.s_addr = inet_addr("10.3.52.255");	// broadcast address

    int inputLength = sizeof(struct sockaddr_in);
    int n;
    int value;
    char buffer[MSG_SIZE];

    while (1)
    {
        // Clean buffer with bzero since not all messages are the same length.
        bzero(buffer, MSG_SIZE);

        // receive message from socket
        n = recvfrom(sckt, buffer, MSG_SIZE, 0, (struct sockaddr *)&server, &inputLength);
        if (n < 0)
           error("recvfrom"); 

        //Log received message
        printf("Received a message. It says: %s\n", buffer);

        //Indiscriminately pass message on to Arduino
        sendSPIMessage(buffer);
    }

    return 0;
}

//Function to send message to arduino via SPI
void sendSPIMessage(char message[MSG_SIZE]){
    uint8_t a[] = {'0'};
	uint8_t b[] = {'0'};

    //First two garbage bits. For some reason the Arduino SPI consumes these before it starts receiving the message
	wiringPiSPIDataRW(1,a,1);
	wiringPiSPIDataRW(1,b,1);

    //Save input into buffer
	char input[10];
	snprintf(input,sizeof(input),"%s",message);
	
    //Write low to SS to specify to the Arduino an SPI message for it is arriving
	digitalWrite(7,0);

    //Send message via SPI
	wiringPiSPIDataRW(1,input,strlen(input));

    //Write high to SS to specify to the Arduino the spi message has finished sending
    digitalWrite(7,1);

	printf("Sent data: %s\n",input);
}
