

#include <stdio.h>  
#include <unistd.h>
#include <AL/al.h> 
#include <AL/alc.h> 
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <ctime> 
#include <fstream>
#include <string>
#include <cstring>
#include <cstdlib>
#include <iostream>
#include "SimpleGPIO.h"
#include <pthread.h>
#include <fcntl.h>

#define MAX_NUM_BUFFERS 10  // Maximum number of bufffers in a bufferArray
#define BYTES_PER_BUFFER 1048576 // Number of ALubytes per sample. 
#define FREQUENCY 44100	// Sampling frequency.
#define MAX_CAPTURE_CHUNK 1024 // Maximum chunk of samples to each time in the while loops.

using namespace std; 

unsigned int recGPIO = 15;   // GPIO0_15 = (0x32) + 15 = 15
unsigned int playGPIO = 60;   // GPIO1_28 = (1x32) + 28 = 60
int stopPressed = 0;
int recordFlag = 0, playFlag = 0 ,exitFlag = 0;

int recStop=0;
int playStop=0;

int fd;


class openAL{
	private: 
		const ALCchar 	*devices; 
		const ALCchar 	*ptr; 
		ALCcontext 		*mainContext;
		ALCdevice 		*mainDev;
		ALCdevice 		*captureDev;  
		ALubyte        **bufferArray; 
		ALubyte         *captureBufPtr; 
		ALint            samplesAvailable; 
		ALint            samplesCaptured; 
		time_t           currentTime; 
		time_t           lastTime; 
		ALuint           *buffer; 
		
		ALint            playState;
		int 			 final_capture_index;
		int				 bufferCounter;
	public:
		unsigned int 	 NUM_ACTIVE_BUFFERS;
		ALuint           source; 

		openAL();
		~openAL();
		void listPlaybackDevices(void);
		void listCaptureDevices(void);
		void playbackSound(void);
		int captureSound(void);
		void endOpenAL(void);
		int preparePlayback(void);
		unsigned int playPB, recPB;
		void reallocateBuffers(void);
};	
 												 
openAL::openAL(){
	// Initialize GPIO ports 
	gpio_export(recGPIO);   
	gpio_set_dir(recGPIO, INPUT_PIN);   
	gpio_export(playGPIO);   
	gpio_set_dir(playGPIO, INPUT_PIN); 
	recPB = HIGH;
	playPB = HIGH;
	
	// Initialize bufferArray 
	bufferArray = new ALubyte*[MAX_NUM_BUFFERS];
	int i;
	for(i = 0; i < MAX_NUM_BUFFERS; i++){
		bufferArray[i] = new ALubyte[BYTES_PER_BUFFER]; 
	}
	NUM_ACTIVE_BUFFERS = 0;
	final_capture_index = 0;
}

openAL::~openAL(){
	int i;
	for(i = 0; i < MAX_NUM_BUFFERS; i++){
		delete[] bufferArray[i];
	}
	delete[] bufferArray;
}

// Prints the List of Playback Devices 
void openAL::listPlaybackDevices(void){
	printf("Available playback devices:\n");
	devices = alcGetString(NULL, ALC_DEVICE_SPECIFIER); 
	ptr = devices; 
	while(*ptr){ 
	   printf("   %s\n", ptr); 
	   ptr += strlen(ptr) + 1; 
	} 
}

// Print the list of capture devices.
void openAL::listCaptureDevices(void){
	printf("Available capture devices:\n"); 
	devices = alcGetString(NULL, ALC_CAPTURE_DEVICE_SPECIFIER); 
	ptr = devices; 
	while (*ptr){ 
	   printf("   %s\n", ptr); 
	   ptr += strlen(ptr) + 1; 
	}
}

// Opens the default playback device and prepares it for playback.
int openAL::preparePlayback(void){
	// Open the default playback device.
	printf("Opening playback device...\n"); 
	mainDev = alcOpenDevice(NULL); 
	if (mainDev == NULL) { 
	  printf("Error. Unable to open playback device.\n"); 
	  return 0; 
	} 

	// Create a playback context.
	devices = alcGetString(mainDev, ALC_DEVICE_SPECIFIER); 
	printf("Opened device '%s'\n", devices); 
	mainContext = alcCreateContext(mainDev, NULL); 
	if (mainContext == NULL) 
	{ 
	  printf("Error. Unable to create playback context.\n"); 
	  return 0;
	} 

	// Make the playback context current 
	alcMakeContextCurrent(mainContext); 
	alcProcessContext(mainContext); 

	// Generate an array of openAL buffers and a single source to attatch them to. 
	buffer = new ALuint[NUM_ACTIVE_BUFFERS];
	alGenBuffers(NUM_ACTIVE_BUFFERS, buffer); 
	alGenSources(1, &source); 
	
	// Fill the openAL buffer array with the data from the captured bufferArray.
	int i;
	for(i=0; i < NUM_ACTIVE_BUFFERS; i++){		
		if(i == NUM_ACTIVE_BUFFERS - 1)		
			alBufferData(buffer[i], AL_FORMAT_MONO16, bufferArray[i], final_capture_index , 44100);
		else
			alBufferData(buffer[i], AL_FORMAT_MONO16, bufferArray[i], BYTES_PER_BUFFER , FREQUENCY);
	}

	// Attatch the buffers to the source.
	alSourceQueueBuffers(source, NUM_ACTIVE_BUFFERS, buffer); 

	return 1;
}


// Plays back the previously captured sound.  
void openAL::playbackSound(void){
	printf("Starting playback...\n"); 
	fflush(stdout); 

	// Play the source, stop if the playback button is pressed again. 
	alSourcePlay(source); 
	playState = AL_PLAYING; 
	playPB = HIGH;
	alSourcei(source, AL_LOOPING,1);
	
	while((playState == AL_PLAYING) && (playPB != LOW)) 
	{ 
	  printf("Source is playing...\r"); 
	  fflush(stdout); 
	  alGetSourcei(source, AL_SOURCE_STATE, &playState);
	  gpio_get_value(playGPIO, &playPB); 
	} 
	alSourceStop(source); 
}

// Captures audio from the defualt device. 
int openAL::captureSound(void){
	// Open the default device 
	recordFlag=0;
	printf("Opening capture device:\n"); 
	captureDev = alcCaptureOpenDevice(NULL, FREQUENCY, AL_FORMAT_MONO16, MAX_CAPTURE_CHUNK); 
	if(captureDev == NULL){  
	  printf("Error. Unable to open device!\n"); 
	  return 0; 
	} 
	devices = alcGetString(captureDev, ALC_CAPTURE_DEVICE_SPECIFIER); 
	printf("Opened device %s\n.", devices);

	// Cowntdown to capture start.
	int i;
	for (i = 3; i > 0; i--) { 
	  printf("Starting capture in %d...\r", i); 
	  fflush(stdout); 
	  lastTime = time(NULL); 
	  currentTime = lastTime; 
	  while(currentTime == lastTime){ 
		 currentTime = time(NULL); 
		 usleep(100000); 
	  } 
	}

	// Initialize capture device and variables.
	printf("Starting capture...\n"); 
	fflush(stdout); 
	alcCaptureStart(captureDev); 
	samplesCaptured = 0; 
	recPB = HIGH;
	captureBufPtr = bufferArray[0]; 
	NUM_ACTIVE_BUFFERS++;
	int buffer_index = 0;
	
	double MAX_TIME = BYTES_PER_BUFFER / (2 * FREQUENCY);	// Maximum recording time.
	//MAX_TIME -= NUM_ACTIVE_BUFFERS;
	cout << "The maximum capture time is " << MAX_TIME << " seconds." << endl; 	

	// Capture audio until the button is pressed or we run out of memory.
	currentTime = time(NULL);
	time_t startTime = currentTime;
	while((currentTime < (startTime + MAX_TIME))){ 
		printf("Capture time: %d\r", currentTime - startTime);
		fflush(stdout);
		// Copy the samples to the current capture buffer.
		alcGetIntegerv(captureDev, ALC_CAPTURE_SAMPLES, 1, &samplesAvailable); // Get the number of samples available
		if(samplesAvailable > 0){ 
			
			alcCaptureSamples(captureDev, captureBufPtr, samplesAvailable); 
			samplesCaptured += samplesAvailable;  
			// Advance the buffer and buffer_index (two bytes per sample * number of samples) 
			captureBufPtr += samplesAvailable * 2;
			buffer_index += samplesAvailable * 2; 
		} 
		
		currentTime = time(NULL); 
		//gpio_get_value(recGPIO, &recPB);
		 if(stopPressed){
			 break;
		 }
	} 
	
	// Stop capture. 
	printf("\nCapture Stopped.\n"); 
	cout << "There are " << NUM_ACTIVE_BUFFERS << " buffers active." << endl;
	alcCaptureStop(captureDev); 
	final_capture_index = buffer_index;

	return 1;
}

// Deletes and reallocates the buffers, effectively clearing them. 
void openAL::reallocateBuffers(void){
	int i;
	for(i=0; i < MAX_NUM_BUFFERS; i++){
		delete[] bufferArray[i];
	}
	delete[] bufferArray; 
	
	bufferArray = new ALubyte*[MAX_NUM_BUFFERS];
	for(i = 0; i < MAX_NUM_BUFFERS; i++){
		bufferArray[i] = new ALubyte[BYTES_PER_BUFFER]; 
	}
	
	NUM_ACTIVE_BUFFERS = 0;
	final_capture_index = 0;

	cout << "Buffers reallocated." << endl;
}

openAL looper;
//thread to check buttons and set flags to be checked in main
void *buttonThread(void *arg){
	char buffer;
	while(1){
		read(fd,&buffer,sizeof(buffer));
		printf("%c\n",buffer);
		if(buffer=='R'){
			if(recStop){
				stopPressed = 1;
				//recordFlag = 0;
				recStop=0;
			}
			else{
				recordFlag=1;
				recStop=1;
			}
		}
		if(buffer=='P'){
			
			if(playStop){
				playStop = 0;
				playFlag=0;
				alSourceStop(looper.source); 
			}
			else{
				playFlag=1;
				playStop=1;
			}
		}
		if(buffer=='X'){
			exitFlag = 1;
		}
	}
}
//record thread calls capture
void *recordSample(void *arg){
	
	if(looper.captureSound() == 0){
		return 0;
	}
	if(looper.preparePlayback() == 0){
		return 0;
	}
	
	recStop=0;
		pthread_exit(0);
	
	
}

//main is pretty sparse, infinite loop that calls different functions based on interrupts provided

int main(void) { 
	
	pthread_t recordThread,playbackThread,buttonCheck;
	
	pthread_create(&buttonCheck,NULL,buttonThread,NULL);
	
	time_t timeoutCurr, timeoutEnd;
	bool flag = true;
	
	fd = open("/dev/looperFIFO",O_RDONLY);
	

	looper.listCaptureDevices();
	
	
	while(1){			
		
		if(recordFlag){
			pthread_create(&recordThread,NULL,recordSample,NULL);
			recordFlag=0;
		}
		if(playFlag){
			looper.playbackSound();
			
		}
		if(exitFlag){
			return 0;
		}
	}
}